/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance.update.v0;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.applifecycle.AppUpdater;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.repository.ApplicationPropertiesRepository;
import org.jphototagger.maintainance.RefreshExifOfKnownFilesInRepository;
import org.openide.util.Lookup;

public final class ExifDateTimeOriginalTimestampUpdater
implements AppUpdater,
ProgressListener {
    private static final String KEY_UPDATED = "ExifDateTimeOriginalTimestampUpdater.Updated";
    private final ApplicationPropertiesRepository repo = (ApplicationPropertiesRepository)Lookup.getDefault().lookup(ApplicationPropertiesRepository.class);
    private final RefreshExifOfKnownFilesInRepository refreshExifTask = new RefreshExifOfKnownFilesInRepository();

    public void updateToVersion(int major, int minor1, int minor2) {
        if (this.repo.existsKey(KEY_UPDATED)) {
            return;
        }
        Logger.getLogger(ExifDateTimeOriginalTimestampUpdater.class.getName()).log(Level.INFO, "Updating database for all known images with the EXIF time of day");
        this.refreshExifTask.addProgressListener(this);
        this.refreshExifTask.start();
    }

    public void progressStarted(ProgressEvent evt) {
    }

    public void progressPerformed(ProgressEvent evt) {
    }

    public void progressEnded(ProgressEvent evt) {
        if (!this.refreshExifTask.isCanceled()) {
            this.repo.setBoolean(KEY_UPDATED, true);
        }
        this.refreshExifTask.removeProgressListener(this);
    }
}

