/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileSystemView;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.concurrent.CancelRequest;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.metadata.event.UpdateMetadataCheckEvent;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.domain.repository.SaveToOrUpdateFilesInRepository;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.comparator.FileSort;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.SelectRootFilesPanel;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CollectionUtil;
import org.jphototagger.maintainance.ImageFileDirectory;
import org.openide.util.Lookup;

public final class UpdateMetadataOfDirectoriesPanel
extends JPanel
implements ProgressListener {
    private static final String KEY_LAST_DIRECTORY = "org.jphototagger.program.view.ScanDirectoriesDialog.lastSelectedDirectory";
    private static final String KEY_FORCE = "org.jphototagger.program.view.ScanDirectoriesDialog.force";
    private static final String KEY_SUBDIRECTORIES = "org.jphototagger.program.view.ScanDirectoriesDialog.subdirectories";
    private static final long serialVersionUID = 1L;
    private final DefaultListModel<Object> listModelDirectories = new DefaultListModel();
    private File lastDirectory = new File("");
    private static final transient Logger LOGGER = Logger.getLogger(UpdateMetadataOfDirectoriesPanel.class.getName());
    private transient SaveToOrUpdateFilesInRepository repositoryUpdater = (SaveToOrUpdateFilesInRepository)Lookup.getDefault().lookup(SaveToOrUpdateFilesInRepository.class);
    private volatile transient boolean cancelChooseDirectories;
    private final transient CancelChooseRequest cancelChooseRequest = new CancelChooseRequest();
    private JButton buttonCancel;
    private JButton buttonCancelChooseDirectories;
    private JButton buttonChooseDirectories;
    private JButton buttonStart;
    private JCheckBox checkBoxForce;
    private JCheckBox checkBoxIncludeSubdirectories;
    private JLabel labelCurrentFilename;
    private JLabel labelFilecount;
    private JLabel labelHeadingListDirectories;
    private JLabel labelInfoCurrentFilename;
    private JLabel labelInfoFilecount;
    private JXList list;
    private JMenuItem menuItemDelete;
    private JPanel panelButtons;
    private JPanel panelCurrentFile;
    private JPopupMenu popupMenu;
    private JProgressBar progressBar;
    private JScrollPane scrollPane;

    public UpdateMetadataOfDirectoriesPanel() {
        this.initComponents();
        this.readProperties();
        MnemonicUtil.setMnemonics((Container)this);
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    public void willDispose() {
        this.interruptImageFileInsterter();
        this.writeProperties();
    }

    private void handleListKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeSelectedDirectories();
        }
    }

    private void removeSelectedDirectories() {
        int selectedIndex = this.list.getSelectedIndex();
        if (selectedIndex >= 0) {
            for (Object selectedValue : this.list.getSelectedValues()) {
                this.listModelDirectories.removeElement(selectedValue);
            }
            this.buttonStart.setEnabled(!this.listModelDirectories.isEmpty());
            this.labelFilecount.setText(Integer.toString(this.getFileCount()));
            ListUtil.selectNearestIndex((JList)this.list, (int)selectedIndex);
            this.list.requestFocusInWindow();
        }
    }

    private int getFileCount() {
        int count = 0;
        for (Object element : this.listModelDirectories.toArray()) {
            count += ((ImageFileDirectory)element).getImageFileCount();
        }
        return count;
    }

    private void startUpdate() {
        List<File> selectedImageFiles = this.getSelectedImageFiles();
        this.updateWillStart(selectedImageFiles.size());
        this.createImageFileInserter(selectedImageFiles);
        this.repositoryUpdater.saveOrUpdateInNewThread();
    }

    private void updateWillStart(int filecount) {
        this.setEnabledButtons(true);
        this.setEnabledCheckboxes(true);
        this.setProgressBarPreStartUpdate(filecount);
        this.list.setEnabled(false);
    }

    private void setProgressBarPreStartUpdate(int filecount) {
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(filecount);
    }

    private List<File> getSelectedImageFiles() {
        ArrayList<File> imageFiles = new ArrayList<File>();
        for (Object element : this.listModelDirectories.toArray()) {
            imageFiles.addAll(((ImageFileDirectory)element).getImageFiles());
        }
        return imageFiles;
    }

    private void createImageFileInserter(List<File> selectedImageFiles) {
        SaveOrUpdate[] insertIntoRepository = this.getWhatToInsertIntoRepository();
        this.repositoryUpdater = ((SaveToOrUpdateFilesInRepository)Lookup.getDefault().lookup(SaveToOrUpdateFilesInRepository.class)).createInstance(selectedImageFiles, insertIntoRepository);
        this.repositoryUpdater.addProgressListener((ProgressListener)this);
    }

    private SaveOrUpdate[] getWhatToInsertIntoRepository() {
        SaveOrUpdate[] saveOrUpdateArray;
        if (this.checkBoxForce.isSelected()) {
            SaveOrUpdate[] saveOrUpdateArray2 = new SaveOrUpdate[3];
            saveOrUpdateArray2[0] = SaveOrUpdate.EXIF;
            saveOrUpdateArray2[1] = SaveOrUpdate.THUMBNAIL;
            saveOrUpdateArray = saveOrUpdateArray2;
            saveOrUpdateArray2[2] = SaveOrUpdate.XMP;
        } else {
            SaveOrUpdate[] saveOrUpdateArray3 = new SaveOrUpdate[1];
            saveOrUpdateArray = saveOrUpdateArray3;
            saveOrUpdateArray3[0] = SaveOrUpdate.OUT_OF_DATE;
        }
        return saveOrUpdateArray;
    }

    private void cancelUpdate() {
        this.interruptImageFileInsterter();
    }

    private synchronized void interruptImageFileInsterter() {
        if (this.repositoryUpdater != null) {
            this.repositoryUpdater.cancel();
        }
    }

    private void setEnabledButtons(boolean isUpdate) {
        this.buttonChooseDirectories.setEnabled(!isUpdate);
        this.buttonStart.setEnabled(!isUpdate);
        this.buttonCancel.setEnabled(isUpdate);
    }

    private void setEnabledCheckboxes(boolean isUpdate) {
        this.checkBoxForce.setEnabled(!isUpdate);
        this.checkBoxIncludeSubdirectories.setEnabled(!isUpdate);
    }

    private void setEnabledMenuItems() {
        boolean itemIsSelected = this.list.getSelectedIndex() >= 0;
        this.menuItemDelete.setEnabled(itemIsSelected && this.list.isEnabled());
    }

    private void readProperties() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            prefs.applyToggleButtonSettings(KEY_FORCE, (JToggleButton)this.checkBoxForce);
            prefs.applyToggleButtonSettings(KEY_SUBDIRECTORIES, (JToggleButton)this.checkBoxIncludeSubdirectories);
            this.readLastDirectoryFromProperties();
        }
    }

    private void readLastDirectoryFromProperties() {
        File directory;
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        String lastDirectoryName = prefs.getString(KEY_LAST_DIRECTORY);
        if (!lastDirectoryName.isEmpty() && (directory = new File(lastDirectoryName)).exists() && directory.isDirectory()) {
            this.lastDirectory = directory;
        }
    }

    private void writeProperties() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setToggleButton(KEY_FORCE, (JToggleButton)this.checkBoxForce);
        prefs.setToggleButton(KEY_SUBDIRECTORIES, (JToggleButton)this.checkBoxIncludeSubdirectories);
        prefs.setString(KEY_LAST_DIRECTORY, this.lastDirectory.getAbsolutePath());
    }

    @EventSubscriber(eventClass=UpdateMetadataCheckEvent.class)
    public void checkForUpdate(UpdateMetadataCheckEvent evt) {
        if (evt.getType().equals((Object)UpdateMetadataCheckEvent.Type.CHECKING_FILE)) {
            File file = evt.getImageFile();
            if (file != null) {
                this.setFileLabel(file);
            }
        } else if (evt.getType().equals((Object)UpdateMetadataCheckEvent.Type.CHECK_FINISHED)) {
            this.repositoryUpdater = null;
            this.updateFinished();
        }
    }

    private void setFileLabel(final File file) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateMetadataOfDirectoriesPanel.this.labelCurrentFilename.setText(file.getAbsolutePath());
            }
        });
    }

    private void updateFinished() {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateMetadataOfDirectoriesPanel.this.setEnabledButtons(false);
                UpdateMetadataOfDirectoriesPanel.this.setEnabledCheckboxes(false);
                UpdateMetadataOfDirectoriesPanel.this.labelCurrentFilename.setText("-");
                UpdateMetadataOfDirectoriesPanel.this.list.setEnabled(true);
            }
        });
    }

    public void progressStarted(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateMetadataOfDirectoriesPanel.this.progressBar.setMinimum(evt.getMinimum());
                UpdateMetadataOfDirectoriesPanel.this.progressBar.setMaximum(evt.getMaximum());
                UpdateMetadataOfDirectoriesPanel.this.progressBar.setValue(evt.getValue());
            }
        });
    }

    public void progressPerformed(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateMetadataOfDirectoriesPanel.this.progressBar.setValue(evt.getValue());
            }
        });
    }

    public void progressEnded(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateMetadataOfDirectoriesPanel.this.progressBar.setValue(evt.getValue());
            }
        });
    }

    private void chooseDirectories() {
        List hideRootFiles = SelectRootFilesPanel.readPersistentRootFiles((String)"UserSettings.HideRootFilesFromDirectoriesTab");
        DirectoryChooser dlg = new DirectoryChooser(ComponentUtil.findFrameWithIcon(), this.lastDirectory, (Collection)hideRootFiles, new DirectoryChooser.Option[]{this.getDirChooserOptionShowHiddenDirs()});
        this.buttonChooseDirectories.setEnabled(false);
        dlg.setPreferencesKey("UpdateMetadataOfDirectoriesPanel.DirChooser");
        dlg.setVisible(true);
        ComponentUtil.parentWindowToFront((Component)this);
        if (dlg.isAccepted()) {
            List selectedDirs = dlg.getSelectedDirectories();
            this.lastDirectory = (File)selectedDirs.get(0);
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString(Bundle.getString(UpdateMetadataOfDirectoriesPanel.class, (String)"UpdateMetadataOfDirectoriesPanel.Info.ScanningDirs", (Object[])new Object[0]));
            this.cancelChooseDirectories = false;
            this.cancelChooseRequest.cancel = false;
            this.buttonCancelChooseDirectories.setEnabled(true);
            new AddNotContainedDirectories(selectedDirs).start();
        } else {
            this.buttonChooseDirectories.setEnabled(true);
        }
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private List<File> getDirectoriesNotInListModelFrom(List<File> directories) {
        ArrayList<File> newDirectories = new ArrayList<File>();
        LOGGER.log(Level.INFO, "Searching directories not previously added from {0}", directories);
        for (File directory : directories) {
            if (this.cancelChooseDirectories) {
                return newDirectories;
            }
            if (this.listModelDirectories.contains(directory)) continue;
            LOGGER.log(Level.INFO, "Found not previously added directory {0}", directory);
            newDirectories.add(directory);
        }
        return newDirectories;
    }

    private void addDirectories(List<File> directories) {
        LOGGER.log(Level.INFO, "Adding directories {0}", directories);
        Collections.sort(directories, FileSort.PATHS_ASCENDING.getComparator());
        for (File directory : directories) {
            if (this.cancelChooseDirectories) {
                return;
            }
            LOGGER.log(Level.INFO, "Searching image files in directory {0}", directory);
            ImageFileDirectory imageFileDir = new ImageFileDirectory(directory);
            if (!imageFileDir.hasImageFiles() || this.listModelDirectories.contains(imageFileDir)) continue;
            this.listModelDirectories.addElement(imageFileDir);
        }
    }

    private void addSubdirectories(List<File> directories) {
        ArrayList subdirectories = new ArrayList();
        DirectoryFilter.Option showHiddenFiles = this.getDirFilterOptionShowHiddenFiles();
        for (File dir : directories) {
            if (this.cancelChooseDirectories) {
                return;
            }
            LOGGER.log(Level.INFO, "Searching recursively subdirectories of {0}", dir);
            subdirectories.addAll(FileUtil.getSubDirectoriesRecursive((File)dir, (CancelRequest)this.cancelChooseRequest, (DirectoryFilter.Option[])new DirectoryFilter.Option[]{showHiddenFiles}));
        }
        LOGGER.log(Level.INFO, "Adding from {0} not previously added directories to {1}", new Object[]{subdirectories, directories});
        CollectionUtil.addNotContainedElements(subdirectories, directories);
    }

    private DirectoryFilter.Option getDirFilterOptionShowHiddenFiles() {
        return this.isAcceptHiddenDirectories() ? DirectoryFilter.Option.ACCEPT_HIDDEN_FILES : DirectoryFilter.Option.NO_OPTION;
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.menuItemDelete = new JMenuItem();
        this.labelHeadingListDirectories = new JLabel();
        this.scrollPane = new JScrollPane();
        this.list = new JXList();
        this.labelInfoFilecount = new JLabel();
        this.labelFilecount = new JLabel();
        this.checkBoxForce = new JCheckBox();
        this.checkBoxIncludeSubdirectories = new JCheckBox();
        this.panelCurrentFile = new JPanel();
        this.labelInfoCurrentFilename = new JLabel();
        this.labelCurrentFilename = new JLabel();
        this.progressBar = new JProgressBar();
        this.panelButtons = new JPanel();
        this.buttonCancelChooseDirectories = new JButton();
        this.buttonCancel = new JButton();
        this.buttonChooseDirectories = new JButton();
        this.buttonStart = new JButton();
        this.popupMenu.setName("popupMenu");
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                UpdateMetadataOfDirectoriesPanel.this.popupMenuPopupMenuWillBecomeVisible(evt);
            }
        });
        this.menuItemDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/maintainance/delete.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/maintainance/Bundle");
        this.menuItemDelete.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.menuItemDelete.text"));
        this.menuItemDelete.setName("menuItemDelete");
        this.menuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateMetadataOfDirectoriesPanel.this.menuItemDeleteActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemDelete);
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.labelHeadingListDirectories.setLabelFor((Component)this.list);
        this.labelHeadingListDirectories.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.labelHeadingListDirectories.text"));
        this.labelHeadingListDirectories.setName("labelHeadingListDirectories");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.labelHeadingListDirectories, gridBagConstraints);
        this.scrollPane.setName("scrollPane");
        this.list.setModel(this.listModelDirectories);
        this.list.setCellRenderer((ListCellRenderer)new DirectoriesListCellRenderer());
        this.list.setComponentPopupMenu(this.popupMenu);
        this.list.setName("list");
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UpdateMetadataOfDirectoriesPanel.this.listKeyReleased(evt);
            }
        });
        this.scrollPane.setViewportView((Component)this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.labelInfoFilecount.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.labelInfoFilecount.text"));
        this.labelInfoFilecount.setName("labelInfoFilecount");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.labelInfoFilecount, gridBagConstraints);
        this.labelFilecount.setForeground(new Color(0, 153, 0));
        this.labelFilecount.setText("0");
        this.labelFilecount.setName("labelFilecount");
        this.labelFilecount.setPreferredSize(new Dimension(4, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.labelFilecount, gridBagConstraints);
        this.checkBoxForce.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.checkBoxForce.text"));
        this.checkBoxForce.setName("checkBoxForce");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.checkBoxForce, gridBagConstraints);
        this.checkBoxIncludeSubdirectories.setSelected(true);
        this.checkBoxIncludeSubdirectories.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.checkBoxIncludeSubdirectories.text"));
        this.checkBoxIncludeSubdirectories.setName("checkBoxIncludeSubdirectories");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.checkBoxIncludeSubdirectories, gridBagConstraints);
        this.panelCurrentFile.setName("panelCurrentFile");
        this.panelCurrentFile.setLayout(new GridBagLayout());
        this.labelInfoCurrentFilename.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.labelInfoCurrentFilename.text"));
        this.labelInfoCurrentFilename.setName("labelInfoCurrentFilename");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelCurrentFile.add((Component)this.labelInfoCurrentFilename, gridBagConstraints);
        this.labelCurrentFilename.setForeground(new Color(51, 51, 255));
        this.labelCurrentFilename.setName("labelCurrentFilename");
        this.labelCurrentFilename.setPreferredSize(new Dimension(4, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelCurrentFile.add((Component)this.labelCurrentFilename, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelCurrentFile, gridBagConstraints);
        this.progressBar.setFocusable(false);
        this.progressBar.setName("progressBar");
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.progressBar, gridBagConstraints);
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new GridLayout(1, 0, 5, 0));
        this.buttonCancelChooseDirectories.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.buttonCancelChooseDirectories.text"));
        this.buttonCancelChooseDirectories.setEnabled(false);
        this.buttonCancelChooseDirectories.setName("buttonCancelChooseDirectories");
        this.buttonCancelChooseDirectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateMetadataOfDirectoriesPanel.this.buttonCancelChooseDirectoriesActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonCancelChooseDirectories);
        this.buttonCancel.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.buttonCancel.text"));
        this.buttonCancel.setEnabled(false);
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateMetadataOfDirectoriesPanel.this.buttonCancelActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonCancel);
        this.buttonChooseDirectories.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.buttonChooseDirectories.text"));
        this.buttonChooseDirectories.setName("buttonChooseDirectories");
        this.buttonChooseDirectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateMetadataOfDirectoriesPanel.this.buttonChooseDirectoriesActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonChooseDirectories);
        this.buttonStart.setText(bundle.getString("UpdateMetadataOfDirectoriesPanel.buttonStart.text"));
        this.buttonStart.setEnabled(false);
        this.buttonStart.setName("buttonStart");
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateMetadataOfDirectoriesPanel.this.buttonStartActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonStart);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void listKeyReleased(KeyEvent evt) {
        this.handleListKeyReleased(evt);
    }

    private void buttonChooseDirectoriesActionPerformed(ActionEvent evt) {
        this.chooseDirectories();
    }

    private void buttonStartActionPerformed(ActionEvent evt) {
        this.startUpdate();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancelUpdate();
    }

    private void menuItemDeleteActionPerformed(ActionEvent evt) {
        this.removeSelectedDirectories();
    }

    private void popupMenuPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.setEnabledMenuItems();
    }

    private void buttonCancelChooseDirectoriesActionPerformed(ActionEvent evt) {
        this.cancelChooseDirectories = true;
        this.cancelChooseRequest.cancel = true;
    }

    private static class DirectoriesListCellRenderer
    extends DefaultListCellRenderer {
        private static final FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();
        private static final long serialVersionUID = 1L;

        private DirectoriesListCellRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            ImageFileDirectory directoryInfo = (ImageFileDirectory)value;
            File dir = directoryInfo.getDirectory();
            if (dir.exists()) {
                FileSystemView fileSystemView = FILE_SYSTEM_VIEW;
                synchronized (fileSystemView) {
                    try {
                        label.setIcon(FILE_SYSTEM_VIEW.getSystemIcon(dir));
                    }
                    catch (Throwable t) {
                        Logger.getLogger(DirectoriesListCellRenderer.class.getName()).log(Level.SEVERE, null, t);
                    }
                }
            }
            label.setText(DirectoriesListCellRenderer.getLabelText(directoryInfo));
            return label;
        }

        private static String getLabelText(ImageFileDirectory directoryInfo) {
            return Bundle.getString(DirectoriesListCellRenderer.class, (String)"DirectoriesListCellRenderer.LabelText", (Object[])new Object[]{directoryInfo.getDirectory().getAbsolutePath(), directoryInfo.getImageFileCount()});
        }
    }

    private static class CancelChooseRequest
    implements CancelRequest {
        boolean cancel;

        private CancelChooseRequest() {
        }

        public boolean isCancel() {
            return this.cancel;
        }
    }

    private class AddNotContainedDirectories
    extends Thread {
        private final List<File> directories;

        AddNotContainedDirectories(List<File> directories) {
            super("JPhotoTagger: Adding directories for updating metadata");
            this.directories = new ArrayList<File>(directories);
        }

        @Override
        public void run() {
            final List newDirectories = UpdateMetadataOfDirectoriesPanel.this.getDirectoriesNotInListModelFrom(this.directories);
            LOGGER.log(Level.INFO, "Adding previously added directories {0} to {1}", new Object[]{newDirectories, this.directories});
            CollectionUtil.addNotContainedElements(this.directories, (Collection)newDirectories);
            if (UpdateMetadataOfDirectoriesPanel.this.checkBoxIncludeSubdirectories.isSelected()) {
                LOGGER.log(Level.INFO, "Adding recursively all not previously added subdirectories of {0}", newDirectories);
                UpdateMetadataOfDirectoriesPanel.this.addSubdirectories(newDirectories);
            }
            EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    UpdateMetadataOfDirectoriesPanel.this.addDirectories(newDirectories);
                    UpdateMetadataOfDirectoriesPanel.this.labelFilecount.setText(Integer.toString(UpdateMetadataOfDirectoriesPanel.this.getFileCount()));
                    UpdateMetadataOfDirectoriesPanel.this.buttonStart.setEnabled(!UpdateMetadataOfDirectoriesPanel.this.listModelDirectories.isEmpty());
                    UpdateMetadataOfDirectoriesPanel.this.buttonChooseDirectories.setEnabled(true);
                    UpdateMetadataOfDirectoriesPanel.this.buttonCancelChooseDirectories.setEnabled(false);
                    UpdateMetadataOfDirectoriesPanel.this.progressBar.setIndeterminate(false);
                    UpdateMetadataOfDirectoriesPanel.this.progressBar.setString(null);
                }
            });
        }
    }
}

