/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.ProgressDialog;
import org.jphototagger.lib.swing.SizeAndLocationController;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class UpdateAllThumbnails
implements Runnable,
ProgressListener,
ActionListener {
    private ProgressDialog progressDialog;
    private boolean cancel;
    private final Set<ActionListener> actionListeners = new HashSet<ActionListener>();
    private static final Logger LOGGER = Logger.getLogger(UpdateAllThumbnails.class.getName());
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);

    public synchronized void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public void run() {
        this.initProgressDialog();
        this.logUpdateAllThumbnails();
        this.repo.updateAllThumbnails((ProgressListener)this);
    }

    private void initProgressDialog() {
        this.progressDialog = new ProgressDialog(ComponentUtil.findFrameWithIcon());
        this.progressDialog.setTitle(Bundle.getString(UpdateAllThumbnails.class, (String)"UpdateAllThumbnails.Dialog.Title", (Object[])new Object[0]));
        this.progressDialog.setInfoText(Bundle.getString(UpdateAllThumbnails.class, (String)"UpdateAllThumbnails.Dialog.InfoText", (Object[])new Object[0]));
        this.progressDialog.addActionListener((ActionListener)this);
        this.progressDialog.addWindowListener((WindowListener)new SizeAndLocationController());
        this.progressDialog.setVisible(true);
    }

    private void checkCancel(ProgressEvent evt) {
        if (this.cancel) {
            evt.setCancel(true);
        }
    }

    public void progressStarted(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateAllThumbnails.this.setProgressDialogStarted(evt);
                UpdateAllThumbnails.this.checkCancel(evt);
            }
        });
    }

    public void progressPerformed(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateAllThumbnails.this.setProgressDialogPerformed(evt);
                UpdateAllThumbnails.this.checkCancel(evt);
            }
        });
    }

    public void progressEnded(ProgressEvent evt) {
        this.setProgressDialogEnded(evt);
        this.notifyActionPerformed();
    }

    private void setProgressDialogEnded(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateAllThumbnails.this.progressDialog.setValue(evt.getValue());
                UpdateAllThumbnails.this.progressDialog.setVisible(false);
                UpdateAllThumbnails.this.progressDialog.dispose();
            }
        });
    }

    private void setProgressDialogPerformed(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateAllThumbnails.this.progressDialog.setValue(evt.getValue());
                UpdateAllThumbnails.this.progressDialog.setCurrentProgressInfoText(evt.getInfo().toString());
            }
        });
    }

    private void setProgressDialogStarted(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdateAllThumbnails.this.progressDialog.setMinimum(evt.getMinimum());
                UpdateAllThumbnails.this.progressDialog.setMaximum(evt.getMaximum());
                UpdateAllThumbnails.this.progressDialog.setValue(evt.getValue());
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.cancel = true;
    }

    private void logUpdateAllThumbnails() {
        LOGGER.log(Level.INFO, "Updating all known thumbnails");
    }

    private synchronized void notifyActionPerformed() {
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(new ActionEvent(this, 0, "Cancel"));
        }
    }
}

