/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.concurrent.HelperThread;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.maintainance.RefreshExifOfKnownFilesInRepository;
import org.jphototagger.maintainance.RefreshXmpOfKnownFilesInRepository;
import org.jphototagger.maintainance.RenameFilenamesInRepositoryDialog;
import org.jphototagger.maintainance.UpdateAllThumbnails;

public class RepositoryUpdatePanel
extends JPanel
implements ActionListener,
ProgressListener {
    private static final long serialVersionUID = 1L;
    private static final String BUTTON_TEXT_CANCEL = Bundle.getString(RepositoryUpdatePanel.class, (String)"RepositoryUpdatePanel.DisplayName.Cancel", (Object[])new Object[0]);
    private transient UpdateAllThumbnails thumbnailUpdater;
    private final AbstractButton[] buttons;
    private volatile boolean cancel;
    private JButton buttonRenameFiles;
    private JButton buttonUpdateThumbnails;
    private JLabel labelRefreshExif;
    private JLabel labelRefreshXmp;
    private JLabel labelRenameFiles;
    private JLabel labelUpdateThumbnails;
    private JPanel panelContent;
    private JPanel panelPadding;
    private JPanel panelTasks;
    private JToggleButton toggleButtonRefreshExif;
    private JToggleButton toggleButtonRefreshXmp;

    public RepositoryUpdatePanel() {
        this.initComponents();
        this.buttons = new AbstractButton[]{this.toggleButtonRefreshExif, this.toggleButtonRefreshXmp, this.buttonUpdateThumbnails, this.buttonRenameFiles};
        MnemonicUtil.setMnemonics((Container)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateThumbnails() {
        this.setEnabledAllButtons(false);
        RepositoryUpdatePanel repositoryUpdatePanel = this;
        synchronized (repositoryUpdatePanel) {
            this.thumbnailUpdater = new UpdateAllThumbnails();
            this.thumbnailUpdater.addActionListener(this);
            Thread t = new Thread((Runnable)this.thumbnailUpdater, "JPhotoTagger: Updating all thumbnails");
            t.start();
        }
    }

    private synchronized void updateExif() {
        this.startOrCancelHelperThread(this.toggleButtonRefreshExif, RefreshExifOfKnownFilesInRepository.class);
    }

    private void updateXmp() {
        this.startOrCancelHelperThread(this.toggleButtonRefreshXmp, RefreshXmpOfKnownFilesInRepository.class);
    }

    private synchronized void startOrCancelHelperThread(JToggleButton button, Class<?> helperThreadClass) {
        if (button.isSelected()) {
            try {
                HelperThread helperThread = (HelperThread)helperThreadClass.newInstance();
                this.disableOtherButtons(button);
                helperThread.addProgressListener((ProgressListener)this);
                this.cancel = false;
                helperThread.start();
                button.setText(BUTTON_TEXT_CANCEL);
            }
            catch (Throwable t) {
                Logger.getLogger(RepositoryUpdatePanel.class.getName()).log(Level.SEVERE, null, t);
            }
        } else {
            this.cancel = true;
            this.setEnabledAllButtons(true);
            this.setStartButtonTexts();
        }
    }

    private void setStartButtonTexts() {
        this.toggleButtonRefreshExif.setText(Bundle.getString(RepositoryUpdatePanel.class, (String)"RepositoryUpdatePanel.toggleButtonRefreshExif.text", (Object[])new Object[0]));
        this.toggleButtonRefreshXmp.setText(Bundle.getString(RepositoryUpdatePanel.class, (String)"RepositoryUpdatePanel.toggleButtonRefreshXmp.text", (Object[])new Object[0]));
        this.buttonUpdateThumbnails.setText(Bundle.getString(RepositoryUpdatePanel.class, (String)"RepositoryUpdatePanel.buttonUpdateThumbnails.text", (Object[])new Object[0]));
        this.buttonRenameFiles.setText(Bundle.getString(RepositoryUpdatePanel.class, (String)"RepositoryUpdatePanel.buttonRenameFiles.text", (Object[])new Object[0]));
        MnemonicUtil.setMnemonics((Container)this);
    }

    private synchronized void disableOtherButtons(JToggleButton buttonEnabled) {
        for (AbstractButton button : this.buttons) {
            if (button == buttonEnabled) continue;
            button.setEnabled(false);
        }
    }

    private synchronized void setEnabledAllButtons(boolean enabled) {
        for (AbstractButton button : this.buttons) {
            button.setEnabled(enabled);
        }
    }

    private synchronized void deselectAllToggleButtons() {
        for (AbstractButton button : this.buttons) {
            if (!(button instanceof JToggleButton)) continue;
            ((JToggleButton)button).setSelected(false);
        }
    }

    private void renameFilesInDb() {
        RenameFilenamesInRepositoryDialog dlg = new RenameFilenamesInRepositoryDialog();
        this.setEnabledAllButtons(false);
        dlg.setVisible(true);
        ComponentUtil.parentWindowToFront((Component)this);
        this.setEnabledAllButtons(true);
    }

    private void checkCancel(ProgressEvent evt) {
        if (this.cancel) {
            evt.setCancel(this.cancel);
        }
    }

    public void progressStarted(ProgressEvent evt) {
        this.checkCancel(evt);
    }

    public void progressPerformed(ProgressEvent evt) {
        this.checkCancel(evt);
    }

    public void progressEnded(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RepositoryUpdatePanel.this.checkCancel(evt);
                RepositoryUpdatePanel.this.setEnabledAllButtons(true);
                RepositoryUpdatePanel.this.deselectAllToggleButtons();
                RepositoryUpdatePanel.this.setStartButtonTexts();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        RepositoryUpdatePanel repositoryUpdatePanel = this;
        synchronized (repositoryUpdatePanel) {
            if (evt.getSource() == this.thumbnailUpdater) {
                this.thumbnailUpdater = null;
                this.buttonUpdateThumbnails.setEnabled(true);
                this.setEnabledAllButtons(true);
            }
        }
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.panelTasks = new JPanel();
        this.labelRefreshExif = new JLabel();
        this.toggleButtonRefreshExif = new JToggleButton();
        this.labelRefreshXmp = new JLabel();
        this.toggleButtonRefreshXmp = new JToggleButton();
        this.labelUpdateThumbnails = new JLabel();
        this.buttonUpdateThumbnails = new JButton();
        this.labelRenameFiles = new JLabel();
        this.buttonRenameFiles = new JButton();
        this.panelPadding = new JPanel();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.panelContent.setName("panelContent");
        this.panelContent.setLayout(new GridBagLayout());
        this.panelTasks.setName("panelTasks");
        this.panelTasks.setLayout(new GridBagLayout());
        this.labelRefreshExif.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/maintainance/exif.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/maintainance/Bundle");
        this.labelRefreshExif.setText(bundle.getString("RepositoryUpdatePanel.labelRefreshExif.text"));
        this.labelRefreshExif.setName("labelRefreshExif");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panelTasks.add((Component)this.labelRefreshExif, gridBagConstraints);
        this.toggleButtonRefreshExif.setText(bundle.getString("RepositoryUpdatePanel.toggleButtonRefreshExif.text"));
        this.toggleButtonRefreshExif.setHorizontalAlignment(2);
        this.toggleButtonRefreshExif.setName("toggleButtonRefreshExif");
        this.toggleButtonRefreshExif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryUpdatePanel.this.toggleButtonRefreshExifActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelTasks.add((Component)this.toggleButtonRefreshExif, gridBagConstraints);
        this.labelRefreshXmp.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/maintainance/xmp.png")));
        this.labelRefreshXmp.setText(bundle.getString("RepositoryUpdatePanel.labelRefreshXmp.text"));
        this.labelRefreshXmp.setName("labelRefreshXmp");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.labelRefreshXmp, gridBagConstraints);
        this.toggleButtonRefreshXmp.setText(bundle.getString("RepositoryUpdatePanel.toggleButtonRefreshXmp.text"));
        this.toggleButtonRefreshXmp.setHorizontalAlignment(2);
        this.toggleButtonRefreshXmp.setName("toggleButtonRefreshXmp");
        this.toggleButtonRefreshXmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryUpdatePanel.this.toggleButtonRefreshXmpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.panelTasks.add((Component)this.toggleButtonRefreshXmp, gridBagConstraints);
        this.labelUpdateThumbnails.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/maintainance/image.png")));
        this.labelUpdateThumbnails.setText(bundle.getString("RepositoryUpdatePanel.labelUpdateThumbnails.text"));
        this.labelUpdateThumbnails.setName("labelUpdateThumbnails");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.labelUpdateThumbnails, gridBagConstraints);
        this.buttonUpdateThumbnails.setText(bundle.getString("RepositoryUpdatePanel.buttonUpdateThumbnails.text"));
        this.buttonUpdateThumbnails.setHorizontalAlignment(2);
        this.buttonUpdateThumbnails.setName("buttonUpdateThumbnails");
        this.buttonUpdateThumbnails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryUpdatePanel.this.buttonUpdateThumbnailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.panelTasks.add((Component)this.buttonUpdateThumbnails, gridBagConstraints);
        this.labelRenameFiles.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/maintainance/rename.png")));
        this.labelRenameFiles.setText(bundle.getString("RepositoryUpdatePanel.labelRenameFiles.text"));
        this.labelRenameFiles.setName("labelRenameFiles");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.labelRenameFiles, gridBagConstraints);
        this.buttonRenameFiles.setText(bundle.getString("RepositoryUpdatePanel.buttonRenameFiles.text"));
        this.buttonRenameFiles.setHorizontalAlignment(2);
        this.buttonRenameFiles.setName("buttonRenameFiles");
        this.buttonRenameFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryUpdatePanel.this.buttonRenameFilesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.panelTasks.add((Component)this.buttonRenameFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.panelTasks, gridBagConstraints);
        this.panelPadding.setName("panelPadding");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelContent.add((Component)this.panelPadding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.panelContent, gridBagConstraints);
    }

    private void toggleButtonRefreshExifActionPerformed(ActionEvent evt) {
        this.updateExif();
    }

    private void buttonRenameFilesActionPerformed(ActionEvent evt) {
        this.renameFilesInDb();
    }

    private void toggleButtonRefreshXmpActionPerformed(ActionEvent evt) {
        this.updateXmp();
    }

    private void buttonUpdateThumbnailsActionPerformed(ActionEvent evt) {
        this.updateThumbnails();
    }
}

