/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.maintainance.CompressRepository;
import org.jphototagger.maintainance.DeleteNotReferenced1n;
import org.jphototagger.maintainance.DeleteOrphanedThumbnails;
import org.jphototagger.maintainance.DeleteOrphanedXmp;
import org.jphototagger.maintainance.DeleteUnusedKeywordsFromRepository;
import org.openide.util.Lookup;

public final class RepositoryMaintainancePanel
extends JPanel
implements ProgressListener {
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_FINISHED = IconUtil.getImageIcon(RepositoryMaintainancePanel.class, (String)"finished.png");
    private static final String KEY_DEL_RECORDS_OF_NOT_EX_FILES = "RepositoryMaintainancePanel.CheckBox.DeleteNotExistingFilesFromDb";
    private static final String KEY_COMPRESS_DB = "RepositoryMaintainancePanel.CheckBox.CompressDb";
    private static final String KEY_DEL_ORPHANED_THUMBS = "RepositoryMaintainancePanel.CheckBox.DeleteOrphanedThumbnails";
    private final String KEY_DEL_UNUSED_KEYWORDS = "RepositoryMaintainancePanel.CheckBox.DeleteUnusedKeywords";
    private static final String KEY_DEL_NOT_REF_1_N = "RepositoryMaintainancePanel.CheckBox.DeleteNotRef1n";
    private final Stack<Runnable> runnables = new Stack();
    private final Map<Class<?>, JLabel> finishedLabelOfRunnable = new HashMap();
    private final Set<JCheckBox> checkBoxes = new HashSet<JCheckBox>();
    private final Map<JCheckBox, JLabel> labelOfCheckBox = new HashMap<JCheckBox, JLabel>();
    private final HTMLDocument messagesDocument = new HTMLDocument();
    private final HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
    private volatile Runnable currentRunnable;
    private volatile boolean containsMessages;
    private volatile boolean cancel;
    private volatile boolean canClose = true;
    private JButton buttonCancelAction;
    private JButton buttonDeleteMessages;
    private JButton buttonStartMaintain;
    private JCheckBox checkBoxCompressRepository;
    private JCheckBox checkBoxDeleteNotReferenced1n;
    private JCheckBox checkBoxDeleteOrphanedThumbnails;
    private JCheckBox checkBoxDeleteRecordsOfNotExistingFilesInRepository;
    private JCheckBox checkBoxDeleteUnusedKeywords;
    private JLabel labelFinishedCompressRepository;
    private JLabel labelFinishedDeleteNotReferenced1n;
    private JLabel labelFinishedDeleteOrphanedThumbnails;
    private JLabel labelFinishedDeleteRecordsOfNotExistingFilesInRepository;
    private JLabel labelFinishedDeleteUnusedKeywords;
    private JLabel labelMessages;
    private JPanel panelButtons;
    private JPanel panelContent;
    private JPanel panelMessages;
    private JPanel panelTasks;
    private JProgressBar progressBar;
    private JScrollPane scrollPaneMessages;
    private JTextPane textPaneMessages;

    public RepositoryMaintainancePanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.textPaneMessages.setEditorKit(this.htmlEditorKit);
        this.textPaneMessages.setDocument(this.messagesDocument);
        this.finishedLabelOfRunnable.put(CompressRepository.class, this.labelFinishedCompressRepository);
        this.finishedLabelOfRunnable.put(DeleteOrphanedXmp.class, this.labelFinishedDeleteRecordsOfNotExistingFilesInRepository);
        this.finishedLabelOfRunnable.put(DeleteOrphanedThumbnails.class, this.labelFinishedDeleteOrphanedThumbnails);
        this.finishedLabelOfRunnable.put(DeleteUnusedKeywordsFromRepository.class, this.labelFinishedDeleteUnusedKeywords);
        this.finishedLabelOfRunnable.put(DeleteNotReferenced1n.class, this.labelFinishedDeleteNotReferenced1n);
        this.initCheckBoxes();
        MnemonicUtil.setMnemonics((Container)this);
    }

    private void initCheckBoxes() {
        this.checkBoxes.add(this.checkBoxCompressRepository);
        this.checkBoxes.add(this.checkBoxDeleteOrphanedThumbnails);
        this.checkBoxes.add(this.checkBoxDeleteRecordsOfNotExistingFilesInRepository);
        this.checkBoxes.add(this.checkBoxDeleteUnusedKeywords);
        this.checkBoxes.add(this.checkBoxDeleteNotReferenced1n);
        this.labelOfCheckBox.put(this.checkBoxCompressRepository, this.labelFinishedCompressRepository);
        this.labelOfCheckBox.put(this.checkBoxDeleteOrphanedThumbnails, this.labelFinishedDeleteOrphanedThumbnails);
        this.labelOfCheckBox.put(this.checkBoxDeleteRecordsOfNotExistingFilesInRepository, this.labelFinishedDeleteRecordsOfNotExistingFilesInRepository);
        this.labelOfCheckBox.put(this.checkBoxDeleteUnusedKeywords, this.labelFinishedDeleteUnusedKeywords);
        this.labelOfCheckBox.put(this.checkBoxDeleteNotReferenced1n, this.labelFinishedDeleteNotReferenced1n);
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            this.checkBoxCompressRepository.setSelected(prefs.getBoolean(KEY_COMPRESS_DB));
            this.checkBoxDeleteOrphanedThumbnails.setSelected(prefs.getBoolean(KEY_DEL_ORPHANED_THUMBS));
            this.checkBoxDeleteRecordsOfNotExistingFilesInRepository.setSelected(prefs.getBoolean(KEY_DEL_RECORDS_OF_NOT_EX_FILES));
            this.checkBoxDeleteUnusedKeywords.setSelected(prefs.getBoolean("RepositoryMaintainancePanel.CheckBox.DeleteUnusedKeywords"));
            this.checkBoxDeleteNotReferenced1n.setSelected(prefs.getBoolean(KEY_DEL_NOT_REF_1_N));
        }
    }

    private void setProgressbarStart(ProgressEvent evt) {
        final boolean indeterminate = evt.isIndeterminate();
        final int minimum = evt.getMinimum();
        final int maximum = evt.getMaximum();
        final int value = evt.getValue();
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (indeterminate) {
                    RepositoryMaintainancePanel.this.progressBar.setIndeterminate(true);
                } else {
                    RepositoryMaintainancePanel.this.progressBar.setMinimum(minimum);
                    RepositoryMaintainancePanel.this.progressBar.setMaximum(maximum);
                    RepositoryMaintainancePanel.this.progressBar.setValue(value);
                }
            }
        });
    }

    private void setProgressbarEnd(ProgressEvent evt) {
        final int value = evt.getValue();
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RepositoryMaintainancePanel.this.progressBar.isIndeterminate()) {
                    RepositoryMaintainancePanel.this.progressBar.setIndeterminate(false);
                } else {
                    RepositoryMaintainancePanel.this.progressBar.setValue(value);
                }
            }
        });
    }

    public void getsVisible(boolean visible) {
        if (visible) {
            this.resetIcons();
            this.checkCheckboxes();
        }
    }

    private void resetIcons() {
        this.labelFinishedCompressRepository.setIcon(null);
        this.labelFinishedDeleteRecordsOfNotExistingFilesInRepository.setIcon(null);
        this.labelFinishedDeleteOrphanedThumbnails.setIcon(null);
        this.progressBar.setValue(0);
    }

    private void checkCheckboxes() {
        this.buttonStartMaintain.setEnabled(this.isACheckBoxSelected());
        this.removeFinishedIcons();
    }

    private boolean isACheckBoxSelected() {
        for (JCheckBox checkBox : this.checkBoxes) {
            if (!checkBox.isSelected()) continue;
            return true;
        }
        return false;
    }

    private void removeFinishedIcons() {
        for (JCheckBox checkBox : this.checkBoxes) {
            if (checkBox.isSelected()) continue;
            this.labelOfCheckBox.get(checkBox).setIcon(null);
        }
    }

    private void setCanClose(boolean can) {
        this.canClose = can;
    }

    public boolean canClose() {
        return this.canClose;
    }

    private synchronized void startNextThread() {
        if (this.runnables.size() > 0) {
            this.currentRunnable = this.runnables.pop();
            String threadName = "JPhotoTagger: Repository maintainance next task @ " + this.currentRunnable.getClass().getSimpleName();
            Thread thread = new Thread(this.currentRunnable, threadName);
            thread.start();
        }
    }

    private void setRunnablesAreRunning(boolean running) {
        this.buttonCancelAction.setEnabled(running);
        this.buttonStartMaintain.setEnabled(!running);
        this.buttonDeleteMessages.setEnabled(!running);
        this.setCanClose(!running);
    }

    private void cancelCurrentRunnable() {
        if (this.currentRunnable == null) {
            return;
        }
        Object methodCancel = null;
        if (this.currentRunnable instanceof Cancelable) {
            ((Cancelable)this.currentRunnable).cancel();
        }
        if (methodCancel == null && this.currentRunnable instanceof Thread) {
            ((Thread)this.currentRunnable).interrupt();
        }
    }

    private void startMaintain() {
        this.resetIcons();
        this.addRunnables();
        this.setRunnablesAreRunning(true);
        this.cancel = false;
        this.startNextThread();
    }

    private synchronized void addRunnables() {
        Runnable runnable;
        this.runnables.clear();
        if (this.checkBoxDeleteOrphanedThumbnails.isSelected()) {
            runnable = new DeleteOrphanedThumbnails();
            ((DeleteOrphanedThumbnails)runnable).addProgressListener(this);
            this.runnables.push(runnable);
        }
        if (this.checkBoxCompressRepository.isSelected()) {
            runnable = new CompressRepository();
            ((CompressRepository)runnable).addProgressListener(this);
            this.runnables.push(runnable);
        }
        if (this.checkBoxDeleteRecordsOfNotExistingFilesInRepository.isSelected()) {
            runnable = new DeleteOrphanedXmp();
            ((DeleteOrphanedXmp)runnable).addProgressListener(this);
            this.runnables.push(runnable);
        }
        if (this.checkBoxDeleteUnusedKeywords.isSelected()) {
            runnable = new DeleteUnusedKeywordsFromRepository();
            ((DeleteUnusedKeywordsFromRepository)runnable).addProgressListener(this);
            this.runnables.push(runnable);
        }
        if (this.checkBoxDeleteNotReferenced1n.isSelected()) {
            runnable = new DeleteNotReferenced1n();
            ((DeleteNotReferenced1n)runnable).addProgressListener(this);
            this.runnables.push(runnable);
        }
    }

    private void checkCancel(ProgressEvent evt) {
        if (this.cancel) {
            evt.setCancel(true);
        }
    }

    private void appendMessage(Object info, String formatPattern) {
        String message;
        if (info != null && !(message = info.toString().trim()).isEmpty()) {
            this.appendMessage(MessageFormat.format(formatPattern, message));
        }
    }

    private void appendMessage(String message) {
        int length = this.messagesDocument.getLength();
        try {
            this.htmlEditorKit.insertHTML(this.messagesDocument, length, message, 0, 0, null);
            this.buttonDeleteMessages.setEnabled(true);
            this.containsMessages = true;
        }
        catch (Throwable t) {
            Logger.getLogger(RepositoryMaintainancePanel.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public void progressStarted(final ProgressEvent evt) {
        final Object info = evt.getInfo();
        this.checkCancel(evt);
        this.setProgressbarStart(evt);
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RepositoryMaintainancePanel.this.appendMessage(info, (RepositoryMaintainancePanel.this.containsMessages ? "<hr>" : "") + "<p><font color=\"#008800\">{0}</font>");
                RepositoryMaintainancePanel.this.buttonDeleteMessages.setEnabled(false);
                RepositoryMaintainancePanel.this.buttonCancelAction.setEnabled(!(evt.getSource() instanceof CompressRepository));
            }
        });
    }

    public void progressPerformed(ProgressEvent evt) {
        final Object info = evt.getInfo();
        final int value = evt.getValue();
        this.checkCancel(evt);
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RepositoryMaintainancePanel.this.progressBar.setValue(value);
                RepositoryMaintainancePanel.this.appendMessage(info, "{0}");
            }
        });
    }

    public void progressEnded(ProgressEvent evt) {
        final Object info = evt.getInfo();
        this.setProgressbarEnd(evt);
        final Object source = evt.getSource();
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RepositoryMaintainancePanel.this.appendMessage(info, "<font color=\"#0000dd\">{0}</font>");
                Class<?> sourceClass = source.getClass();
                JLabel labelFinished = (JLabel)RepositoryMaintainancePanel.this.finishedLabelOfRunnable.get(sourceClass);
                RepositoryMaintainancePanel.this.progressBar.setValue(0);
                if (labelFinished != null) {
                    labelFinished.setIcon(ICON_FINISHED);
                } else if (sourceClass.getName().contains("ImageFilesDatabase")) {
                    RepositoryMaintainancePanel.this.labelFinishedDeleteRecordsOfNotExistingFilesInRepository.setIcon(ICON_FINISHED);
                }
                if (RepositoryMaintainancePanel.this.runnables.size() > 0) {
                    RepositoryMaintainancePanel.this.startNextThread();
                } else {
                    RepositoryMaintainancePanel.this.currentRunnable = null;
                    RepositoryMaintainancePanel.this.setRunnablesAreRunning(false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleButtonCancelActionPerformed() {
        this.cancel = true;
        Stack<Runnable> stack = this.runnables;
        synchronized (stack) {
            this.cancelCurrentRunnable();
            this.runnables.clear();
            this.setRunnablesAreRunning(false);
            this.currentRunnable = null;
        }
    }

    private void deleteMessages() {
        this.textPaneMessages.setText("");
        this.containsMessages = false;
        this.buttonDeleteMessages.setEnabled(false);
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.panelTasks = new JPanel();
        this.checkBoxDeleteRecordsOfNotExistingFilesInRepository = new JCheckBox();
        this.labelFinishedDeleteRecordsOfNotExistingFilesInRepository = new JLabel();
        this.checkBoxCompressRepository = new JCheckBox();
        this.labelFinishedCompressRepository = new JLabel();
        this.checkBoxDeleteOrphanedThumbnails = new JCheckBox();
        this.labelFinishedDeleteOrphanedThumbnails = new JLabel();
        this.checkBoxDeleteUnusedKeywords = new JCheckBox();
        this.labelFinishedDeleteUnusedKeywords = new JLabel();
        this.checkBoxDeleteNotReferenced1n = new JCheckBox();
        this.labelFinishedDeleteNotReferenced1n = new JLabel();
        this.panelMessages = new JPanel();
        this.labelMessages = new JLabel();
        this.scrollPaneMessages = new JScrollPane();
        this.textPaneMessages = new JTextPane();
        this.progressBar = new JProgressBar();
        this.panelButtons = new JPanel();
        this.buttonDeleteMessages = new JButton();
        this.buttonCancelAction = new JButton();
        this.buttonStartMaintain = new JButton();
        this.panelContent.setLayout(new GridBagLayout());
        this.panelTasks.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/maintainance/Bundle");
        this.checkBoxDeleteRecordsOfNotExistingFilesInRepository.setText(bundle.getString("RepositoryMaintainancePanel.checkBoxDeleteRecordsOfNotExistingFilesInRepository.text"));
        this.checkBoxDeleteRecordsOfNotExistingFilesInRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryMaintainancePanel.this.checkBoxDeleteRecordsOfNotExistingFilesInRepositoryActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelTasks.add((Component)this.checkBoxDeleteRecordsOfNotExistingFilesInRepository, gridBagConstraints);
        this.labelFinishedDeleteRecordsOfNotExistingFilesInRepository.setBorder(BorderFactory.createEtchedBorder());
        this.labelFinishedDeleteRecordsOfNotExistingFilesInRepository.setIconTextGap(0);
        this.labelFinishedDeleteRecordsOfNotExistingFilesInRepository.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.panelTasks.add((Component)this.labelFinishedDeleteRecordsOfNotExistingFilesInRepository, gridBagConstraints);
        this.checkBoxCompressRepository.setText(bundle.getString("RepositoryMaintainancePanel.checkBoxCompressRepository.text"));
        this.checkBoxCompressRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryMaintainancePanel.this.checkBoxCompressRepositoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.checkBoxCompressRepository, gridBagConstraints);
        this.labelFinishedCompressRepository.setBorder(BorderFactory.createEtchedBorder());
        this.labelFinishedCompressRepository.setIconTextGap(0);
        this.labelFinishedCompressRepository.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.labelFinishedCompressRepository, gridBagConstraints);
        this.checkBoxDeleteOrphanedThumbnails.setText(bundle.getString("RepositoryMaintainancePanel.checkBoxDeleteOrphanedThumbnails.text"));
        this.checkBoxDeleteOrphanedThumbnails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryMaintainancePanel.this.checkBoxDeleteOrphanedThumbnailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.checkBoxDeleteOrphanedThumbnails, gridBagConstraints);
        this.labelFinishedDeleteOrphanedThumbnails.setBorder(BorderFactory.createEtchedBorder());
        this.labelFinishedDeleteOrphanedThumbnails.setIconTextGap(0);
        this.labelFinishedDeleteOrphanedThumbnails.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.labelFinishedDeleteOrphanedThumbnails, gridBagConstraints);
        this.checkBoxDeleteUnusedKeywords.setText(bundle.getString("RepositoryMaintainancePanel.checkBoxDeleteUnusedKeywords.text"));
        this.checkBoxDeleteUnusedKeywords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryMaintainancePanel.this.checkBoxDeleteUnusedKeywordsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.checkBoxDeleteUnusedKeywords, gridBagConstraints);
        this.labelFinishedDeleteUnusedKeywords.setBorder(BorderFactory.createEtchedBorder());
        this.labelFinishedDeleteUnusedKeywords.setIconTextGap(0);
        this.labelFinishedDeleteUnusedKeywords.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.labelFinishedDeleteUnusedKeywords, gridBagConstraints);
        this.checkBoxDeleteNotReferenced1n.setText(bundle.getString("RepositoryMaintainancePanel.checkBoxDeleteNotReferenced1n.text"));
        this.checkBoxDeleteNotReferenced1n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryMaintainancePanel.this.checkBoxDeleteNotReferenced1nActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.checkBoxDeleteNotReferenced1n, gridBagConstraints);
        this.labelFinishedDeleteNotReferenced1n.setBorder(BorderFactory.createEtchedBorder());
        this.labelFinishedDeleteNotReferenced1n.setIconTextGap(0);
        this.labelFinishedDeleteNotReferenced1n.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelTasks.add((Component)this.labelFinishedDeleteNotReferenced1n, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.panelTasks, gridBagConstraints);
        this.panelMessages.setLayout(new GridBagLayout());
        this.labelMessages.setText(bundle.getString("RepositoryMaintainancePanel.labelMessages.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.panelMessages.add((Component)this.labelMessages, gridBagConstraints);
        this.textPaneMessages.setEditable(false);
        this.textPaneMessages.setContentType("text/html");
        this.scrollPaneMessages.setViewportView(this.textPaneMessages);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelMessages.add((Component)this.scrollPaneMessages, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.panelMessages, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.progressBar, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.buttonDeleteMessages.setText(bundle.getString("RepositoryMaintainancePanel.buttonDeleteMessages.text"));
        this.buttonDeleteMessages.setEnabled(false);
        this.buttonDeleteMessages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryMaintainancePanel.this.buttonDeleteMessagesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelButtons.add((Component)this.buttonDeleteMessages, gridBagConstraints);
        this.buttonCancelAction.setText(bundle.getString("RepositoryMaintainancePanel.buttonCancelAction.text"));
        this.buttonCancelAction.setEnabled(false);
        this.buttonCancelAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryMaintainancePanel.this.buttonCancelActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panelButtons.add((Component)this.buttonCancelAction, gridBagConstraints);
        this.buttonStartMaintain.setText(bundle.getString("RepositoryMaintainancePanel.buttonStartMaintain.text"));
        this.buttonStartMaintain.setEnabled(false);
        this.buttonStartMaintain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryMaintainancePanel.this.buttonStartMaintainActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelButtons.add((Component)this.buttonStartMaintain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.panelButtons, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelContent, -1, 384, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelContent, -1, 371, Short.MAX_VALUE).addContainerGap()));
    }

    private void checkBoxDeleteRecordsOfNotExistingFilesInRepositoryActionPerformed(ActionEvent evt) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean(KEY_DEL_RECORDS_OF_NOT_EX_FILES, this.checkBoxDeleteRecordsOfNotExistingFilesInRepository.isSelected());
        this.checkCheckboxes();
    }

    private void checkBoxCompressRepositoryActionPerformed(ActionEvent evt) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean(KEY_COMPRESS_DB, this.checkBoxCompressRepository.isSelected());
        this.checkCheckboxes();
    }

    private void buttonStartMaintainActionPerformed(ActionEvent evt) {
        this.startMaintain();
    }

    private void buttonCancelActionActionPerformed(ActionEvent evt) {
        this.handleButtonCancelActionPerformed();
    }

    private void buttonDeleteMessagesActionPerformed(ActionEvent evt) {
        this.deleteMessages();
    }

    private void checkBoxDeleteOrphanedThumbnailsActionPerformed(ActionEvent evt) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean(KEY_DEL_ORPHANED_THUMBS, this.checkBoxDeleteOrphanedThumbnails.isSelected());
        this.checkCheckboxes();
    }

    private void checkBoxDeleteUnusedKeywordsActionPerformed(ActionEvent evt) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean("RepositoryMaintainancePanel.CheckBox.DeleteUnusedKeywords", this.checkBoxDeleteUnusedKeywords.isSelected());
        this.checkCheckboxes();
    }

    private void checkBoxDeleteNotReferenced1nActionPerformed(ActionEvent evt) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean(KEY_DEL_NOT_REF_1_N, this.checkBoxDeleteNotReferenced1n.isSelected());
        this.checkCheckboxes();
    }
}

