/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesHints;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.TabbedPaneUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.maintainance.RepositoryInfoCountPanel;
import org.jphototagger.maintainance.RepositoryMaintainancePanel;
import org.jphototagger.maintainance.RepositoryUpdatePanel;
import org.openide.util.Lookup;

public final class RepositoryMaintainanceDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    public static final RepositoryMaintainanceDialog INSTANCE = new RepositoryMaintainanceDialog();
    private RepositoryInfoCountPanel panelCount;
    private RepositoryMaintainancePanel panelMaintainance;
    private RepositoryUpdatePanel panelRepositoryUpdate;
    private JTabbedPane tabbedPane;

    private RepositoryMaintainanceDialog() {
        super(ComponentUtil.findFrameWithIcon(), false);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        TabbedPaneUtil.setMnemonics((JTabbedPane)this.tabbedPane);
        AnnotationProcessor.process((Object)((Object)this));
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(RepositoryMaintainanceDialog.class, (String)"RepositoryMaintainanceDialog.HelpPage", (Object[])new Object[0]));
    }

    public void setVisible(boolean visible) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (visible) {
            prefs.applyComponentSettings((Component)((Object)this), new PreferencesHints(new PreferencesHints.Option[]{PreferencesHints.Option.SET_TABBED_PANE_CONTENT}));
        } else {
            prefs.setComponent((Component)((Object)this), new PreferencesHints(new PreferencesHints.Option[]{PreferencesHints.Option.SET_TABBED_PANE_CONTENT}));
        }
        this.panelMaintainance.getsVisible(visible);
        this.panelCount.listenToRepositoryChanges(visible);
        super.setVisible(visible);
    }

    private void close() {
        if (this.panelMaintainance.canClose()) {
            Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
            prefs.setComponent((Component)((Object)this), new PreferencesHints(new PreferencesHints.Option[]{PreferencesHints.Option.SET_TABBED_PANE_CONTENT}));
            this.setVisible(false);
        } else {
            String message = Bundle.getString(RepositoryMaintainanceDialog.class, (String)"RepositoryMaintainanceDialog.Error.WaitBeforeClose", (Object[])new Object[0]);
            MessageDisplayer.error((Component)((Object)this), (String)message);
        }
    }

    protected void escape() {
        this.close();
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.panelCount = new RepositoryInfoCountPanel();
        this.panelMaintainance = new RepositoryMaintainancePanel();
        this.panelRepositoryUpdate = new RepositoryUpdatePanel();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/maintainance/Bundle");
        this.setTitle(bundle.getString("RepositoryMaintainanceDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RepositoryMaintainanceDialog.this.formWindowClosing(evt);
            }
        });
        this.tabbedPane.setName("tabbedPane");
        this.panelCount.setName("panelCount");
        this.tabbedPane.addTab(bundle.getString("RepositoryMaintainanceDialog.panelCount.TabConstraints.tabTitle"), this.panelCount);
        this.panelMaintainance.setName("panelMaintainance");
        this.tabbedPane.addTab(bundle.getString("RepositoryMaintainanceDialog.panelMaintainance.TabConstraints.tabTitle"), this.panelMaintainance);
        this.panelRepositoryUpdate.setName("panelRepositoryUpdate");
        this.tabbedPane.addTab(bundle.getString("RepositoryMaintainanceDialog.panelRepositoryUpdate.TabConstraints.tabTitle"), this.panelRepositoryUpdate);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 564, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.close();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepositoryMaintainanceDialog dialog = new RepositoryMaintainanceDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

