/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.file.FilenameTokens;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.selections.RepositoryInfoCountOfMetaDataValues;
import org.jphototagger.domain.repository.FileRepositoryProvider;
import org.jphototagger.domain.repository.RepositoryStatistics;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectDeletedEvent;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectInsertedEvent;
import org.jphototagger.domain.repository.event.exif.ExifDeletedEvent;
import org.jphototagger.domain.repository.event.exif.ExifInsertedEvent;
import org.jphototagger.domain.repository.event.exif.ExifUpdatedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileDeletedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.TableModelExt;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class RepositoryInfoCountPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private RepositoryInfoCountTableModel repositoryInfoTableModel;
    private volatile boolean listenToDbChanges;
    private JLabel labelFilename;
    private JLabel labelTable;
    private JScrollPane scrollPane;
    private JTable table;

    public RepositoryInfoCountPanel() {
        this.initComponents();
        this.table.setDefaultRenderer(Object.class, new RepositoryInfoColumnsTableCellRenderer());
        this.setLabelFilename();
    }

    public void listenToRepositoryChanges(boolean listen) {
        this.listenToDbChanges = listen;
        if (listen) {
            this.setModelRepositoryInfo();
        }
        if (this.repositoryInfoTableModel != null) {
            this.repositoryInfoTableModel.setListenToRepository(listen);
        }
    }

    private void setLabelFilename() {
        String pattern = Bundle.getString(RepositoryInfoCountPanel.class, (String)"RepositoryInfoCountPanel.labelFilename.Filename", (Object[])new Object[0]);
        FileRepositoryProvider provider = (FileRepositoryProvider)Lookup.getDefault().lookup(FileRepositoryProvider.class);
        if (provider != null) {
            String repositoryFileName = provider.getFileRepositoryFileName(FilenameTokens.FULL_PATH);
            String message = MessageFormat.format(pattern, repositoryFileName);
            this.labelFilename.setText(message);
        }
    }

    private void setModelRepositoryInfo() {
        if (this.repositoryInfoTableModel == null) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RepositoryInfoCountPanel.this.repositoryInfoTableModel = new RepositoryInfoCountTableModel();
                            RepositoryInfoCountPanel.this.repositoryInfoTableModel.setListenToRepository(RepositoryInfoCountPanel.this.listenToDbChanges);
                            RepositoryInfoCountPanel.this.table.setModel((TableModel)((Object)RepositoryInfoCountPanel.this.repositoryInfoTableModel));
                            RepositoryInfoCountPanel.this.repositoryInfoTableModel.update();
                        }
                    });
                }
            }, "JPhotoTagger: Updating repository info");
            thread.start();
        } else {
            this.repositoryInfoTableModel.setListenToRepository(true);
            this.repositoryInfoTableModel.update();
        }
    }

    private void initComponents() {
        this.labelTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.labelFilename = new JLabel();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/maintainance/Bundle");
        this.labelTable.setText(bundle.getString("RepositoryInfoCountPanel.labelTable.text"));
        this.labelTable.setName("labelTable");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.labelTable, gridBagConstraints);
        this.scrollPane.setName("scrollPane");
        this.table.setName("table");
        this.scrollPane.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.labelFilename.setText(bundle.getString("RepositoryInfoCountPanel.labelFilename.text"));
        this.labelFilename.setName("labelFilename");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.labelFilename, gridBagConstraints);
    }

    private static class RepositoryInfoCountTableModel
    extends TableModelExt {
        private static final long serialVersionUID = 1L;
        private final LinkedHashMap<MetaDataValue, StringBuffer> bufferOfMetaDataValue = new LinkedHashMap();
        private boolean listenToRepository;
        private final RepositoryStatistics repo = (RepositoryStatistics)Lookup.getDefault().lookup(RepositoryStatistics.class);

        private RepositoryInfoCountTableModel() {
            this.initBufferOfMetaDataValue();
            this.addColumnHeaders();
            this.addRows();
            this.listen();
        }

        private void listen() {
            AnnotationProcessor.process((Object)((Object)this));
        }

        private void initBufferOfMetaDataValue() {
            List metaDataValues = RepositoryInfoCountOfMetaDataValues.get();
            for (MetaDataValue mdValue : metaDataValues) {
                this.bufferOfMetaDataValue.put(mdValue, new StringBuffer());
            }
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void update() {
            if (this.listenToRepository) {
                this.setCount();
            }
        }

        public void setListenToRepository(boolean listen) {
            this.listenToRepository = listen;
        }

        private void addColumnHeaders() {
            this.addColumn(Bundle.getString(RepositoryInfoCountPanel.class, (String)"RepositoryInfoTableModel.HeaderColumn.1", (Object[])new Object[0]));
            this.addColumn(Bundle.getString(RepositoryInfoCountPanel.class, (String)"RepositoryInfoTableModel.HeaderColumn.2", (Object[])new Object[0]));
        }

        private void addRows() {
            Set<MetaDataValue> columns = this.bufferOfMetaDataValue.keySet();
            for (MetaDataValue column : columns) {
                this.addRow(this.getRow(column, this.bufferOfMetaDataValue.get(column)));
            }
        }

        private Object[] getRow(MetaDataValue rowHeader, StringBuffer bufferDifferent) {
            return new Object[]{rowHeader, bufferDifferent};
        }

        private void setCount() {
            new SetCountThread().start();
        }

        @EventSubscriber(eventClass=ImageFileDeletedEvent.class)
        public void imageFileDeleted(ImageFileDeletedEvent evt) {
            this.update();
        }

        @EventSubscriber(eventClass=ImageFileInsertedEvent.class)
        public void imageFileInserted(ImageFileInsertedEvent evt) {
            this.update();
        }

        @EventSubscriber(eventClass=XmpUpdatedEvent.class)
        public void xmpUpdated(XmpUpdatedEvent evt) {
            this.update();
        }

        @EventSubscriber(eventClass=DcSubjectDeletedEvent.class)
        public void dcSubjectDeleted(DcSubjectDeletedEvent evt) {
            this.update();
        }

        @EventSubscriber(eventClass=DcSubjectInsertedEvent.class)
        public void dcSubjectInserted(DcSubjectInsertedEvent evt) {
            this.update();
        }

        @EventSubscriber(eventClass=XmpDeletedEvent.class)
        public void xmpDeleted(XmpDeletedEvent evt) {
            this.update();
        }

        @EventSubscriber(eventClass=ExifInsertedEvent.class)
        public void exifInserted(ExifInsertedEvent evt) {
            this.update();
        }

        @EventSubscriber(eventClass=ExifUpdatedEvent.class)
        public void exifUpdated(ExifUpdatedEvent evt) {
            this.update();
        }

        @EventSubscriber(eventClass=ExifDeletedEvent.class)
        public void exifDeleted(ExifDeletedEvent evt) {
            this.update();
        }

        private void setCountToBuffer(StringBuffer buffer, Integer count) {
            buffer.replace(0, buffer.length(), count.toString());
        }

        private class SetCountThread
        extends Thread {
            SetCountThread() {
                super("JPhotoTagger: Setting count in repository info");
                this.setPriority(1);
            }

            @Override
            public void run() {
                for (MetaDataValue mdValue : RepositoryInfoCountTableModel.this.bufferOfMetaDataValue.keySet()) {
                    RepositoryInfoCountTableModel.this.setCountToBuffer((StringBuffer)RepositoryInfoCountTableModel.this.bufferOfMetaDataValue.get(mdValue), RepositoryInfoCountTableModel.this.repo.getCountOfMetaDataValue(mdValue));
                }
                EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RepositoryInfoCountTableModel.this.fireTableDataChanged();
                    }
                });
            }
        }
    }

    private static class RepositoryInfoColumnsTableCellRenderer
    implements TableCellRenderer {
        private static final String PADDING_LEFT = "  ";
        private final TableCellRenderer delegate = new DefaultTableCellRenderer();

        private RepositoryInfoColumnsTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                MetaDataValue metaDataValue = (MetaDataValue)value;
                label.setIcon(metaDataValue.getCategoryIcon());
                label.setText(metaDataValue.getDescription());
            } else {
                label.setText(PADDING_LEFT + value.toString());
            }
            return label;
        }
    }
}

