/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public class RenameFilenamesInRepositoryPanel
extends JPanel
implements ProgressListener,
Persistence {
    private static final long serialVersionUID = 1L;
    private static final String KEY_SEARCH = "RenameFilenamesInRepositoryPanel.Search";
    private static final String KEY_REPLACEMENT = "RenameFilenamesInRepositoryPanel.Replacement";
    private volatile boolean runs;
    private ButtonGroup buttonGroupPosition;
    private JButton buttonReplace;
    private JLabel labelReplacement;
    private JLabel labelSearch;
    private JLabel labelTitle;
    private JProgressBar progressBar;
    private JTextField textFieldReplacement;
    private JTextField textFieldSearch;

    public RenameFilenamesInRepositoryPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            prefs.applyComponentSettings((Component)this, null);
        }
        this.setButtonReplaceEnabled();
        MnemonicUtil.setMnemonics((Container)this);
    }

    public boolean runs() {
        return this.runs;
    }

    private void replace(final ProgressListener progressListener) {
        if (this.confirmReplace()) {
            this.runs = true;
            this.setInputEnabled(false);
            Thread thread = new Thread(new Runnable(){
                private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);

                @Override
                public void run() {
                    String searchText = RenameFilenamesInRepositoryPanel.this.textFieldSearch.getText();
                    String replacementText = RenameFilenamesInRepositoryPanel.this.textFieldReplacement.getText();
                    int count = this.repo.updateRenameFilenamesStartingWith(searchText, replacementText, progressListener);
                    String message = Bundle.getString(RenameFilenamesInRepositoryPanel.class, (String)"RenameFilenamesInRepositoryPanel.Info.Count", (Object[])new Object[]{count});
                    MessageDisplayer.information(null, (String)message);
                    RenameFilenamesInRepositoryPanel.this.runs = false;
                }
            }, "JPhotoTagger: Renaming files in repository");
            thread.start();
        }
    }

    public void progressStarted(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RenameFilenamesInRepositoryPanel.this.progressBar.setMinimum(evt.getMinimum());
                RenameFilenamesInRepositoryPanel.this.progressBar.setMaximum(evt.getMaximum());
                RenameFilenamesInRepositoryPanel.this.progressBar.setValue(evt.getValue());
            }
        });
    }

    public void progressPerformed(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RenameFilenamesInRepositoryPanel.this.progressBar.setValue(evt.getValue());
            }
        });
    }

    public void progressEnded(ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RenameFilenamesInRepositoryPanel.this.progressBar.setValue(0);
                RenameFilenamesInRepositoryPanel.this.setInputEnabled(true);
            }
        });
    }

    private void setInputEnabled(boolean enabled) {
        this.buttonReplace.setEnabled(enabled);
        this.textFieldSearch.setEnabled(enabled);
        this.textFieldReplacement.setEnabled(enabled);
    }

    private void setButtonReplaceEnabled() {
        String searchText = this.textFieldSearch.getText().trim();
        String replacementText = this.textFieldReplacement.getText().trim();
        boolean textsEquals = searchText.equals(replacementText);
        this.buttonReplace.setEnabled(!searchText.isEmpty() && !replacementText.isEmpty() && !textsEquals);
    }

    private boolean confirmReplace() {
        String searchText = this.textFieldSearch.getText();
        String replacementText = this.textFieldReplacement.getText();
        String message = Bundle.getString(RenameFilenamesInRepositoryPanel.class, (String)"RenameFilenamesInRepositoryPanel.Confirm.Replace", (Object[])new Object[]{searchText, replacementText});
        return MessageDisplayer.confirmYesNo((Component)this, (String)message);
    }

    public void restore() {
        if (this == null) {
            throw new NullPointerException("this == null");
        }
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        this.textFieldSearch.setText(prefs.getString(KEY_SEARCH));
        this.textFieldReplacement.setText(prefs.getString(KEY_REPLACEMENT));
    }

    public void persist() {
        if (this == null) {
            throw new NullPointerException("this == null");
        }
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setString(KEY_SEARCH, this.textFieldSearch.getText());
        prefs.setString(KEY_REPLACEMENT, this.textFieldReplacement.getText());
    }

    private void initComponents() {
        this.buttonGroupPosition = new ButtonGroup();
        this.labelTitle = new JLabel();
        this.labelSearch = new JLabel();
        this.textFieldSearch = new JTextField();
        this.labelReplacement = new JLabel();
        this.textFieldReplacement = new JTextField();
        this.progressBar = new JProgressBar();
        this.buttonReplace = new JButton();
        this.setName("Form");
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/maintainance/Bundle");
        this.labelTitle.setText(bundle.getString("RenameFilenamesInRepositoryPanel.labelTitle.text"));
        this.labelTitle.setName("labelTitle");
        this.labelSearch.setLabelFor(this.textFieldSearch);
        this.labelSearch.setText(bundle.getString("RenameFilenamesInRepositoryPanel.labelSearch.text"));
        this.labelSearch.setName("labelSearch");
        this.textFieldSearch.setName("textFieldSearch");
        this.textFieldSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RenameFilenamesInRepositoryPanel.this.textFieldSearchKeyReleased(evt);
            }
        });
        this.labelReplacement.setLabelFor(this.textFieldReplacement);
        this.labelReplacement.setText(bundle.getString("RenameFilenamesInRepositoryPanel.labelReplacement.text"));
        this.labelReplacement.setName("labelReplacement");
        this.textFieldReplacement.setName("textFieldReplacement");
        this.textFieldReplacement.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RenameFilenamesInRepositoryPanel.this.textFieldReplacementKeyReleased(evt);
            }
        });
        this.progressBar.setName("progressBar");
        this.buttonReplace.setText(bundle.getString("RenameFilenamesInRepositoryPanel.buttonReplace.text"));
        this.buttonReplace.setEnabled(false);
        this.buttonReplace.setName("buttonReplace");
        this.buttonReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameFilenamesInRepositoryPanel.this.buttonReplaceActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelTitle, -1, 354, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelSearch, GroupLayout.Alignment.TRAILING).addComponent(this.labelReplacement, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textFieldSearch, -1, 241, Short.MAX_VALUE).addComponent(this.textFieldReplacement, -1, 241, Short.MAX_VALUE))).addComponent(this.buttonReplace, GroupLayout.Alignment.TRAILING).addComponent(this.progressBar, -1, 354, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelTitle, -2, 17, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textFieldSearch, -2, -1, -2).addComponent(this.labelSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelReplacement).addComponent(this.textFieldReplacement, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonReplace).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.textFieldReplacement, this.textFieldSearch);
    }

    private void buttonReplaceActionPerformed(ActionEvent evt) {
        this.replace(this);
    }

    private void textFieldSearchKeyReleased(KeyEvent evt) {
        this.setButtonReplaceEnabled();
    }

    private void textFieldReplacementKeyReleased(KeyEvent evt) {
        this.setButtonReplaceEnabled();
    }
}

