/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpModifier;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.concurrent.HelperThread;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class RefreshXmpOfKnownFilesInRepository
extends HelperThread {
    private volatile boolean cancel;
    private final XmpSidecarFileResolver xmpSidecarFileResolver = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private final Collection<? extends XmpModifier> xmpModifiers = Lookup.getDefault().lookupAll(XmpModifier.class);
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);

    public RefreshXmpOfKnownFilesInRepository() {
        super("JPhotoTagger: Refreshing XMP in the repository of known files");
        this.setInfo(Bundle.getString(RefreshXmpOfKnownFilesInRepository.class, (String)"RefreshXmpOfKnownFilesInRepository.Info", (Object[])new Object[0]));
    }

    public void run() {
        int fileCount;
        List imageFiles = this.repo.findAllImageFiles();
        this.progressStarted(0, 0, fileCount, (fileCount = imageFiles.size()) > 0 ? (File)imageFiles.get(0) : null);
        for (int i = 0; !this.cancel && !this.isInterrupted() && i < fileCount; ++i) {
            File imageFile = (File)imageFiles.get(i);
            Xmp xmp = null;
            try {
                xmp = this.xmpSidecarFileResolver.hasXmpSidecarFile(imageFile) ? XmpMetadata.getXmpFromSidecarFileOf((File)imageFile) : (this.isScanForEmbeddedXmp() ? XmpMetadata.getEmbeddedXmp((File)imageFile) : null);
            }
            catch (IOException ex) {
                Logger.getLogger(RefreshXmpOfKnownFilesInRepository.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (xmp != null) {
                this.modifyXmp(this.xmpSidecarFileResolver.findSidecarFile(this.xmpSidecarFileResolver.suggestXmpSidecarFile(imageFile)), xmp);
                this.repo.saveOrUpdateXmpOfImageFile(imageFile, xmp);
            }
            this.progressPerformed(i + 1, imageFile.getName());
        }
        this.progressEnded(null);
    }

    private void modifyXmp(File sidecarFile, Xmp xmp) {
        if (sidecarFile == null || xmp == null) {
            return;
        }
        for (XmpModifier xmpModifier : this.xmpModifiers) {
            if (!xmpModifier.modifyXmp(sidecarFile, xmp)) continue;
            XmpMetadata.writeXmpToSidecarFile((Xmp)xmp, (File)sidecarFile);
        }
    }

    private boolean isScanForEmbeddedXmp() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.ScanForEmbeddedXmp") ? prefs.getBoolean("UserSettings.ScanForEmbeddedXmp") : false;
    }

    public void cancel() {
        this.cancel = true;
    }
}

