/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.io.File;
import java.util.List;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.exif.ExifUtil;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.concurrent.HelperThread;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class RefreshExifOfKnownFilesInRepository
extends HelperThread {
    private volatile boolean cancel;
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);

    public RefreshExifOfKnownFilesInRepository() {
        super("JPhotoTagger: Refreshing EXIF in the repository of known files");
        this.setInfo(Bundle.getString(RefreshExifOfKnownFilesInRepository.class, (String)"RefreshExifOfKnownFilesInRepository.Info", (Object[])new Object[0]));
    }

    public void run() {
        int fileCount;
        List imageFiles = this.repo.findAllImageFiles();
        this.progressStarted(0, 0, fileCount, (fileCount = imageFiles.size()) > 0 ? (File)imageFiles.get(0) : null);
        for (int i = 0; !this.cancel && !this.isInterrupted() && i < fileCount; ++i) {
            File imageFile = (File)imageFiles.get(i);
            Exif exif = ExifUtil.readExif((File)imageFile);
            if (exif != null) {
                this.repo.saveOrUpdateExif(imageFile, exif);
            }
            this.progressPerformed(i + 1, imageFile.getName());
        }
        this.progressEnded(null);
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean isCanceled() {
        return this.cancel;
    }
}

