/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jphototagger.domain.filefilter.FileFilterUtil;

public final class ImageFileDirectory {
    private final File directory;
    private final List<File> imageFiles;

    public ImageFileDirectory(File directory) {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        this.directory = directory;
        this.imageFiles = FileFilterUtil.getImageFilesOfDirectory((File)directory);
    }

    public File getDirectory() {
        return this.directory;
    }

    public boolean hasImageFiles() {
        return this.imageFiles.size() > 0;
    }

    public int getImageFileCount() {
        return this.imageFiles.size();
    }

    public List<File> getImageFiles() {
        return Collections.unmodifiableList(this.imageFiles);
    }

    public boolean equals(Object object) {
        if (object instanceof ImageFileDirectory) {
            ImageFileDirectory otherDirectoryInfo = (ImageFileDirectory)object;
            return this.directory.equals(otherDirectoryInfo.directory);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.directory != null ? this.directory.hashCode() : 0);
        return hash;
    }
}

