/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.event.listener.ProgressListenerSupport;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class DeleteUnusedKeywordsFromRepository
implements Runnable,
Cancelable {
    private volatile boolean cancel;
    private final ProgressListenerSupport ls = new ProgressListenerSupport();
    private volatile int countDeleted = 0;
    private static final Logger LOGGER = Logger.getLogger(DeleteUnusedKeywordsFromRepository.class.getName());
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);
    private static final String DELETE_MESSAGE_PATTERN = Bundle.getString(DeleteUnusedKeywordsFromRepository.class, (String)"DeleteUnusedKeywordsFromRepository.DeleteMessagePattern", (Object[])new Object[0]);

    public synchronized void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.ls.add((Object)listener);
    }

    public synchronized int getCountDeleted() {
        return this.countDeleted;
    }

    @Override
    public void run() {
        ArrayList keywords = new ArrayList(this.repo.findNotReferencedDcSubjects());
        int size = keywords.size();
        this.notifyProgressStarted(size);
        for (int i = 0; !this.cancel && i < size; ++i) {
            String keyword = (String)keywords.get(i);
            this.repo.deleteDcSubject(keyword);
            ++this.countDeleted;
            this.notifyProgressPerformed(i + 1, this.countDeleted, keyword);
        }
        this.notifyProgressEnded(size, this.countDeleted);
    }

    public void cancel() {
        this.cancel = true;
    }

    public void notifyProgressStarted(int count) {
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(count).value(0).info(this.getStartMessage()).build();
        LOGGER.log(Level.INFO, "Deleting unused keywords");
        for (ProgressListener listener : this.ls.get()) {
            listener.progressStarted(evt);
            if (!evt.isCancel()) continue;
            this.cancel = true;
        }
    }

    private void notifyProgressPerformed(int count, int countDeleted, String keyword) {
        LOGGER.log(Level.INFO, "Deleted unused keyword ''{0}''", keyword);
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(count).value(countDeleted).info((Object)MessageFormat.format(DELETE_MESSAGE_PATTERN, keyword)).build();
        for (ProgressListener listener : this.ls.get()) {
            listener.progressPerformed(evt);
            if (!evt.isCancel()) continue;
            this.cancel = true;
        }
    }

    public void notifyProgressEnded(int count, int countDeleted) {
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(count).value(countDeleted).info(this.getEndMessage(count, countDeleted)).build();
        this.ls.notifyEnded(evt);
    }

    private Object getEndMessage(int count, int countDeleted) {
        return Bundle.getString(DeleteUnusedKeywordsFromRepository.class, (String)"DeleteUnusedKeywords.Info.Finished", (Object[])new Object[]{count, countDeleted});
    }

    private Object getStartMessage() {
        return Bundle.getString(DeleteUnusedKeywordsFromRepository.class, (String)"DeleteUnusedKeywords.Info.Start", (Object[])new Object[0]);
    }
}

