/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.event.listener.ProgressListenerSupport;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class DeleteOrphanedXmp
implements Runnable,
ProgressListener {
    private final ProgressListenerSupport ls = new ProgressListenerSupport();
    private volatile boolean notifyProgressEnded;
    private volatile boolean cancel;
    private volatile int countDeleted = 0;
    private String startMessage;
    private String endMessage;
    private static final Logger LOGGER = Logger.getLogger(DeleteOrphanedXmp.class.getName());
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);

    @Override
    public void run() {
        this.setMessagesFiles();
        this.logDeleteRecords();
        this.repo.deleteAbsentImageFiles((ProgressListener)this);
        if (!this.cancel) {
            this.setMessagesXmp();
            this.notifyProgressEnded = true;
            this.repo.deleteAbsentXmp((ProgressListener)this);
        }
    }

    public int getCountDeleted() {
        return this.countDeleted;
    }

    public synchronized void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.ls.add((Object)listener);
    }

    public void progressStarted(ProgressEvent evt) {
        evt.setInfo(this.getStartMessage(evt));
        for (ProgressListener listener : this.ls.get()) {
            listener.progressStarted(evt);
            if (!evt.isCancel()) continue;
            this.cancel = true;
        }
    }

    public void progressPerformed(ProgressEvent evt) {
        for (ProgressListener listener : this.ls.get()) {
            listener.progressPerformed(evt);
            if (!evt.isCancel()) continue;
            this.cancel = true;
        }
    }

    public void progressEnded(ProgressEvent evt) {
        this.countDeleted += ((Integer)evt.getInfo()).intValue();
        evt.setInfo(this.getEndMessage());
        if (this.cancel || this.notifyProgressEnded) {
            this.ls.notifyEnded(evt);
        }
    }

    private Object getStartMessage(ProgressEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        return new MessageFormat(this.startMessage).format(new Object[]{evt.getMaximum()});
    }

    private Object getEndMessage() {
        return new MessageFormat(this.endMessage).format(new Object[]{this.countDeleted});
    }

    private void logDeleteRecords() {
        LOGGER.log(Level.INFO, "Delete from repository records with not existing files");
    }

    private void setMessagesFiles() {
        this.startMessage = Bundle.getString(DeleteOrphanedXmp.class, (String)"DeleteOrphanedXmp.Files.Start", (Object[])new Object[0]);
        this.endMessage = Bundle.getString(DeleteOrphanedXmp.class, (String)"DeleteOrphanedXmp.Files.End", (Object[])new Object[0]);
    }

    private void setMessagesXmp() {
        this.startMessage = Bundle.getString(DeleteOrphanedXmp.class, (String)"DeleteOrphanedXmp.Xmp.Start", (Object[])new Object[0]);
        this.endMessage = Bundle.getString(DeleteOrphanedXmp.class, (String)"DeleteOrphanedXmp.Xmp.End", (Object[])new Object[0]);
    }
}

