/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.event.listener.ProgressListenerSupport;
import org.jphototagger.domain.repository.ThumbnailsRepository;
import org.jphototagger.domain.thumbnails.ThumbnailsDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class DeleteOrphanedThumbnails
implements Runnable,
Cancelable {
    private final ProgressListenerSupport ls = new ProgressListenerSupport();
    private int tnCount = 0;
    private int countDeleted = 0;
    private int currentFileIndex = 0;
    private volatile boolean cancel;
    private static final Logger LOGGER = Logger.getLogger(DeleteOrphanedThumbnails.class.getName());

    public synchronized void addProgressListener(ProgressListener l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        this.ls.add((Object)l);
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    @Override
    public void run() {
        ThumbnailsDisplayer thumbnailsDisplayer = (ThumbnailsDisplayer)Lookup.getDefault().lookup(ThumbnailsDisplayer.class);
        ThumbnailsRepository tnRepo = (ThumbnailsRepository)Lookup.getDefault().lookup(ThumbnailsRepository.class);
        Set imageFilenames = tnRepo.getImageFilenames();
        this.tnCount = imageFilenames.size();
        this.notifyStarted();
        for (String imageFilename : imageFilenames) {
            boolean isDelete;
            if (this.cancel) break;
            ++this.currentFileIndex;
            File imageFile = new File(imageFilename);
            boolean bl = isDelete = !imageFile.isFile();
            if (isDelete) {
                this.logDelete(imageFile);
                tnRepo.deleteThumbnail(imageFile);
                ++this.countDeleted;
                if (thumbnailsDisplayer.isDisplayFile(imageFile)) {
                    thumbnailsDisplayer.removeFilesFromDisplay(Arrays.asList(imageFile));
                }
            }
            this.notifyPerformed(imageFile, isDelete);
        }
        this.notifyEnded();
    }

    private synchronized void logDelete(File imageFile) {
        LOGGER.log(Level.INFO, "Deleting orphaned thumbnail for image file ''{0}''", imageFile);
    }

    private synchronized void notifyStarted() {
        LOGGER.log(Level.INFO, "Verifying which of the {0} thumbnails are orphaned", this.tnCount);
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(this.tnCount).value(0).info((Object)this.getStartMessage()).build();
        this.ls.notifyStarted(evt);
    }

    private void notifyPerformed(File file, boolean wasDeleted) {
        LOGGER.log(Level.FINEST, "Verifying wheter thumbnail ''{0}'' is orphaned", file);
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(this.tnCount).value(this.currentFileIndex).info((Object)this.getPerformedMessage(file, wasDeleted)).build();
        this.ls.notifyPerformed(evt);
    }

    private void notifyEnded() {
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(this.tnCount).value(this.currentFileIndex).info((Object)this.getEndMessage()).build();
        this.ls.notifyEnded(evt);
        LOGGER.log(Level.INFO, "Verifying of orphaned thumbnails finished. Deleted {0} thumbnails.", this.currentFileIndex);
    }

    private String getStartMessage() {
        return Bundle.getString(DeleteOrphanedThumbnails.class, (String)"DeleteOrphanedThumbnails.Info.Start", (Object[])new Object[]{this.tnCount});
    }

    private String getPerformedMessage(File file, boolean wasDeleted) {
        return wasDeleted ? Bundle.getString(DeleteOrphanedThumbnails.class, (String)"DeleteOrphanedThumbnails.Info.Performed", (Object[])new Object[]{file}) : null;
    }

    private String getEndMessage() {
        return Bundle.getString(DeleteOrphanedThumbnails.class, (String)"DeleteOrphanedThumbnails.Info.End", (Object[])new Object[]{this.countDeleted});
    }
}

