/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.event.listener.ProgressListenerSupport;
import org.jphototagger.domain.repository.RepositoryMaintainance;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class DeleteNotReferenced1n
implements Runnable {
    private final ProgressListenerSupport ls = new ProgressListenerSupport();
    private volatile int countDeleted = 0;
    private static final Logger LOGGER = Logger.getLogger(DeleteNotReferenced1n.class.getName());

    public synchronized void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.ls.add((Object)listener);
    }

    public synchronized int getCountDeleted() {
        return this.countDeleted;
    }

    @Override
    public void run() {
        this.notifyProgressStarted();
        RepositoryMaintainance repo = (RepositoryMaintainance)Lookup.getDefault().lookup(RepositoryMaintainance.class);
        this.countDeleted = repo.deleteNotReferenced1n();
        this.notifyProgressEnded();
    }

    public void notifyProgressStarted() {
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(1).value(0).info(this.getStartMessage()).build();
        LOGGER.log(Level.INFO, "Deleting not referenced data from the repository");
        this.ls.notifyStarted(evt);
    }

    public void notifyProgressEnded() {
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(1).value(1).info(this.getEndMessage()).build();
        this.ls.notifyEnded(evt);
    }

    private Object getStartMessage() {
        return Bundle.getString(DeleteNotReferenced1n.class, (String)"DeleteNotReferenced1n.Info.Start", (Object[])new Object[0]);
    }

    private Object getEndMessage() {
        return Bundle.getString(DeleteNotReferenced1n.class, (String)"DeleteNotReferenced1n.Info.Finished", (Object[])new Object[]{this.countDeleted});
    }
}

