/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.file.FilenameTokens;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.event.listener.ProgressListenerSupport;
import org.jphototagger.domain.repository.FileRepositoryProvider;
import org.jphototagger.domain.repository.RepositoryMaintainance;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class CompressRepository
implements Runnable {
    private final ProgressListenerSupport listenerSupport = new ProgressListenerSupport();
    private boolean success = false;
    private long sizeBefore;
    private long sizeAfter;
    private static final Logger LOGGER = Logger.getLogger(CompressRepository.class.getName());

    public synchronized void addProgressListener(ProgressListener l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        this.listenerSupport.add((Object)l);
    }

    public boolean getSuccess() {
        return this.success;
    }

    public long getSizeAfter() {
        return this.sizeAfter;
    }

    public long getSizeBefore() {
        return this.sizeBefore;
    }

    @Override
    public void run() {
        LOGGER.log(Level.INFO, "Compressing repository");
        this.notifyStarted();
        FileRepositoryProvider provider = (FileRepositoryProvider)Lookup.getDefault().lookup(FileRepositoryProvider.class);
        File dbFile = new File(provider.getFileRepositoryFileName(FilenameTokens.FULL_PATH));
        RepositoryMaintainance repo = (RepositoryMaintainance)Lookup.getDefault().lookup(RepositoryMaintainance.class);
        this.sizeBefore = dbFile.length();
        this.success = repo.compressRepository();
        this.sizeAfter = dbFile.length();
        this.notifyFinished();
        LOGGER.log(Level.INFO, "Compressing repository finished");
    }

    private synchronized void notifyStarted() {
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).info((Object)Bundle.getString(CompressRepository.class, (String)"CompressRepository.Start", (Object[])new Object[0])).build();
        this.listenerSupport.notifyStarted(evt);
    }

    private synchronized void notifyFinished() {
        ProgressEvent evt = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(1).value(1).info(this.getEndMessage()).build();
        this.listenerSupport.notifyEnded(evt);
    }

    private Object getEndMessage() {
        double mb = 1048576.0;
        Object[] params = new Object[]{this.success ? Bundle.getString(CompressRepository.class, (String)"CompressRepository.End.Success.True", (Object[])new Object[0]) : Bundle.getString(CompressRepository.class, (String)"CompressRepository.End.Success.False", (Object[])new Object[0]), this.sizeBefore, new Double((double)this.sizeBefore / mb), this.sizeAfter, new Double((double)this.sizeAfter / mb)};
        return Bundle.getString(CompressRepository.class, (String)"CompressRepository.End", (Object[])params);
    }
}

