/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.maintainance;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.jphototagger.domain.metadata.exif.ExifCacheProvider;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class ClearExifCacheAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    public static final ClearExifCacheAction INSTANCE = new ClearExifCacheAction();

    private ClearExifCacheAction() {
        super(Bundle.getString(ClearExifCacheAction.class, (String)"ClearExifCacheAction.Name", (Object[])new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.confirm()) {
            int deletedFileCount = ((ExifCacheProvider)Lookup.getDefault().lookup(ExifCacheProvider.class)).clear();
            this.showDeletedFileCountInfo(deletedFileCount);
        }
    }

    public boolean confirm() {
        String message = Bundle.getString(ClearExifCacheAction.class, (String)"ClearExifCacheAction.Confirm", (Object[])new Object[0]);
        return MessageDisplayer.confirmYesNo(null, (String)message);
    }

    private void showDeletedFileCountInfo(int deletedFileCount) {
        String message = Bundle.getString(ClearExifCacheAction.class, (String)"ClearExifCacheAction.Info.DeletedFileCount", (Object[])new Object[]{deletedFileCount});
        MessageDisplayer.information(null, (String)message);
    }
}

