/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exifmodule.comparators;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpIptc4XmpCoreDateCreatedMetaDataValue;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.util.ClassEquality;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class ExifDateTimeOriginalAscendingComparator
extends ClassEquality
implements Comparator<File>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);

    @Override
    public int compare(File fileLeft, File fileRight) {
        long timeRight;
        long timeLeft = this.getTimestampDateTimeOriginalFromRepository(fileLeft);
        return timeLeft == (timeRight = this.getTimestampDateTimeOriginalFromRepository(fileRight)) ? 0 : (timeLeft < timeRight ? -1 : 1);
    }

    private long getTimestampDateTimeOriginalFromRepository(File imageFile) {
        Exif exif = this.repo.findExifOfImageFile(imageFile);
        if (exif == null || exif.getDateTimeOriginal() == null) {
            return ExifDateTimeOriginalAscendingComparator.findDateCreated(imageFile);
        }
        return exif.getDateTimeOriginal().getTime();
    }

    static long findDateCreated(File file) {
        Xmp xmp;
        try {
            xmp = XmpMetadata.getXmpFromSidecarFileOf((File)file);
        }
        catch (IOException ex) {
            Logger.getLogger(ExifDateTimeOriginalAscendingComparator.class.getName()).log(Level.SEVERE, null, ex);
            return file.lastModified();
        }
        if (xmp == null || !xmp.contains((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE)) {
            return file.lastModified();
        }
        String date = (String)xmp.getValue((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE);
        Long timestamp = XmpIptc4XmpCoreDateCreatedMetaDataValue.createTimestamp((String)date);
        return timestamp == null ? file.lastModified() : timestamp.longValue();
    }

    public String toString() {
        return "Exif DateTimeOriginal only Date Ascending";
    }
}

