/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exifmodule;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.exifmodule.SetExifToXmp;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;

public final class SetExifToXmpAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Collection<File> selectedFiles = new ArrayList<File>();

    public SetExifToXmpAction() {
        super(Bundle.getString(SetExifToXmpAction.class, (String)"SetExifToXmpAction.Name", (Object[])new Object[0]));
        this.putValue("SmallIcon", IconUtil.getImageIcon(SetExifToXmpAction.class, (String)"xmp.png"));
        this.setEnabled(false);
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        this.selectedFiles.clear();
        this.selectedFiles.addAll(evt.getSelectedFiles());
        this.setEnabled(!this.selectedFiles.isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.processSelectedFiles();
    }

    private void processSelectedFiles() {
        if (!this.selectedFiles.isEmpty()) {
            boolean replaceExistingXmpData = true;
            SetExifToXmp setExifToXmp = new SetExifToXmp(this.selectedFiles, replaceExistingXmpData);
            setExifToXmp.start();
        }
    }
}

