/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exifmodule;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.image.ImageFile;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.exif.ExifUtil;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpIptc4XmpCoreDateCreatedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpLastModifiedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.lib.concurrent.HelperThread;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class SetExifToXmp
extends HelperThread {
    private static final ImageFilesRepository IMAGE_FILES_REPOSITORY = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);
    private static final XmpSidecarFileResolver XMP_SIDECAR_FILE_RESOLVER = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private List<File> files;
    private final boolean replaceExistingXmpData;
    private volatile boolean cancel;

    public SetExifToXmp() {
        this.replaceExistingXmpData = false;
        this.setInfo();
    }

    public SetExifToXmp(boolean replaceExistingXmpData) {
        this.replaceExistingXmpData = replaceExistingXmpData;
        this.setInfo();
    }

    public SetExifToXmp(Collection<? extends File> imageFiles, boolean replaceExistingXmpData) {
        super("JPhotoTagger: Setting EXIF metadata to XMP metadata");
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        this.replaceExistingXmpData = replaceExistingXmpData;
        this.files = new ArrayList<File>(imageFiles);
        this.setInfo();
    }

    private void setInfo() {
        this.setInfo(Bundle.getString(SetExifToXmp.class, (String)"SetExifToXmp.Info", (Object[])new Object[0]));
    }

    public void run() {
        List<File> imgFiles = this.files == null ? IMAGE_FILES_REPOSITORY.findAllImageFiles() : this.files;
        int fileCount = imgFiles.size();
        this.progressStarted(0, 0, fileCount, fileCount > 0 ? imgFiles.get(0) : null);
        for (int i = 0; !this.cancel && !this.isInterrupted() && i < fileCount; ++i) {
            File imgFile = imgFiles.get(i);
            SetExifToXmp.set(imgFile, this.replaceExistingXmpData);
            this.progressPerformed(i + 1, imgFile.getName());
        }
        this.progressEnded(null);
    }

    public static void set(File file, boolean replaceExistingXmpData) {
        if (file == null) {
            throw new NullPointerException("imgFile == null");
        }
        if (SetExifToXmp.isUserDefinedFileType(file)) {
            return;
        }
        Exif exif = ExifUtil.readExifPreferCached((File)file);
        Xmp xmp = null;
        try {
            xmp = XmpMetadata.getXmpFromSidecarFileOf((File)file);
        }
        catch (IOException ex) {
            Logger.getLogger(SetExifToXmp.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (xmp == null) {
            xmp = new Xmp();
        }
        if (exif != null && SetExifToXmp.exifHasValues(exif) && SetExifToXmp.isSet(xmp, replaceExistingXmpData)) {
            SetExifToXmp.setDateCreated(xmp, exif);
            File xmpFile = XMP_SIDECAR_FILE_RESOLVER.suggestXmpSidecarFile(file);
            if (XmpMetadata.writeXmpToSidecarFile((Xmp)xmp, (File)xmpFile)) {
                ImageFile imageFile = new ImageFile();
                xmp.setValue((MetaDataValue)XmpLastModifiedMetaDataValue.INSTANCE, (Object)xmpFile.lastModified());
                imageFile.setLastmodified(file.lastModified());
                imageFile.setSizeInBytes(file.length());
                imageFile.setFile(file);
                imageFile.setXmp(xmp);
                imageFile.addToSaveIntoRepository(SaveOrUpdate.XMP);
                IMAGE_FILES_REPOSITORY.saveOrUpdateImageFile(imageFile);
            }
        }
    }

    private static boolean isUserDefinedFileType(File file) {
        UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
        String suffix = FileUtil.getSuffix((File)file);
        return repo.existsUserDefinedFileTypeWithSuffix(suffix);
    }

    private static boolean isSet(Xmp xmp, boolean replaceExistingXmpData) {
        return replaceExistingXmpData || !xmp.contains((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE);
    }

    public static boolean exifHasValues(Exif exif) {
        if (exif == null) {
            throw new NullPointerException("exif == null");
        }
        return exif.getDateTimeOriginal() != null;
    }

    public static void setDateCreated(Xmp xmp, Exif exif) {
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        if (exif == null) {
            throw new NullPointerException("exif == null");
        }
        if (exif.getDateTimeOriginal() != null) {
            xmp.setValue((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE, (Object)exif.getXmpDateCreated());
        }
    }

    public void cancel() {
        this.cancel = true;
    }
}

