/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exifmodule;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.metadata.exif.ExifTag;
import org.jphototagger.domain.metadata.exif.ExifUtil;
import org.jphototagger.domain.metadata.exif.event.ExifCacheClearedEvent;
import org.jphototagger.domain.metadata.exif.event.ExifCacheFileDeletedEvent;
import org.jphototagger.lib.awt.DesktopUtil;
import org.jphototagger.lib.swing.TableModelExt;
import org.jphototagger.lib.util.Bundle;

public final class ExifTableModel
extends TableModelExt {
    private static final long serialVersionUID = 1L;
    private File file;

    public ExifTableModel() {
        this.setRowHeaders();
        this.listen();
    }

    private void setRowHeaders() {
        this.addColumn(Bundle.getString(ExifTableModel.class, (String)"ExifTableModel.HeaderColumn.1", (Object[])new Object[0]));
        this.addColumn(Bundle.getString(ExifTableModel.class, (String)"ExifTableModel.HeaderColumn.2", (Object[])new Object[0]));
    }

    private void listen() {
        AnnotationProcessor.process((Object)((Object)this));
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.file = file;
        this.removeAllRows();
        this.addExifTags();
    }

    private void addExifTags() {
        Collection exifTags = ExifUtil.getExifTagsPreferCached((File)this.file);
        for (ExifTag exifTag : exifTags) {
            GpsButtonListener action;
            String name;
            boolean isGoogleMapsUrl = exifTag.getDisplayName().equals(ExifTag.NAME_GOOGLE_MAPS_URL);
            boolean isOpenStreetMapUrl = exifTag.getDisplayName().equals(ExifTag.NAME_OPEN_STREET_MAP_URL);
            if (isGoogleMapsUrl) {
                name = Bundle.getString(ExifTableModel.class, (String)"ExifTableModel.Button.GoogleMaps", (Object[])new Object[0]);
                action = new GpsButtonListener(name, exifTag.getDisplayValue());
                super.addRow(new Object[]{exifTag, new JButton(action)});
                continue;
            }
            if (isOpenStreetMapUrl) {
                name = Bundle.getString(ExifTableModel.class, (String)"ExifTableModel.Button.OpenStreetMap", (Object[])new Object[0]);
                action = new GpsButtonListener(name, exifTag.getDisplayValue());
                super.addRow(new Object[]{exifTag, new JButton(action)});
                continue;
            }
            super.addRow(new Object[]{exifTag, exifTag});
        }
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @EventSubscriber(eventClass=ExifCacheClearedEvent.class)
    public void exifCacheCleared(ExifCacheClearedEvent evt) {
        int deletedCacheFileCount = evt.getDeletedCacheFileCount();
        if (this.file != null && deletedCacheFileCount > 0) {
            this.setFile(this.file);
        }
    }

    @EventSubscriber(eventClass=ExifCacheFileDeletedEvent.class)
    public void exifCacheCleared(ExifCacheFileDeletedEvent evt) {
        File imageFile = evt.getImageFile();
        if (imageFile.equals(this.file)) {
            this.setFile(this.file);
        }
    }

    private class GpsButtonListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final String url;

        GpsButtonListener(String name, String url) {
            super(name);
            this.url = url;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.browse();
        }

        private void browse() {
            DesktopUtil.browse((String)this.url, (String)"JPhotoTagger");
        }
    }
}

