/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exifmodule;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import javax.swing.text.Document;
import org.jphototagger.api.branding.TableLookAndFeel;
import org.jphototagger.domain.metadata.exif.ExifTag;
import org.jphototagger.exifmodule.ExifTableModel;
import org.jphototagger.exifmodule.SetExifToXmpAction;
import org.jphototagger.lib.swing.TableButtonMouseListener;
import org.jphototagger.lib.swing.TableMouseClicker;
import org.jphototagger.lib.swing.TableTextFilter;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.swing.util.TableUtil;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public class ExifPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ExifTableModel exifTableModel = new ExifTableModel();
    private final TableMouseClicker tableMouseClicker;
    private final ExifTableCellRenderer exifTableCellRenderer = new ExifTableCellRenderer();
    private JButton buttonExifToXmp;
    private JLabel labelTableExifFilter;
    private JPanel panelTableExifFilter;
    private JScrollPane scrollPaneExif;
    private JTable tableExif;
    private JTextField textFieldTableExifFilter;

    public ExifPanel() {
        this.initComponents();
        this.tableMouseClicker = new TableMouseClicker(this.tableExif);
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.tableExif.setDefaultRenderer(Object.class, this.exifTableCellRenderer);
        this.setExifTableTextFilter();
        this.setExifTableComparator();
        this.addMouseListener((MouseListener)new TableButtonMouseListener(this.tableExif));
        MnemonicUtil.setMnemonics((Container)this);
    }

    private void setExifTableTextFilter() {
        TableRowSorter rowSorter = (TableRowSorter)this.tableExif.getRowSorter();
        TableStringConverter stringConverter = ExifTableCellRenderer.createTableStringConverter();
        Document document = this.textFieldTableExifFilter.getDocument();
        TableTextFilter tableTextFilter = new TableTextFilter(this.tableExif, stringConverter);
        rowSorter.setStringConverter(stringConverter);
        document.addDocumentListener((DocumentListener)tableTextFilter);
    }

    private void setExifTableComparator() {
        TableRowSorter rowSorter = (TableRowSorter)this.tableExif.getRowSorter();
        Comparator<?> column0Comparator = ExifTableCellRenderer.createColumn0Comparator();
        Comparator<?> column1Comparator = ExifTableCellRenderer.createColumn1Comparator();
        rowSorter.setComparator(0, column0Comparator);
        rowSorter.setComparator(1, column1Comparator);
    }

    void removeAllRows() {
        this.exifTableModel.removeAllRows();
    }

    void setFile(File file) {
        this.exifTableModel.setFile(file);
        this.resizeTable();
    }

    private void resizeTable() {
        TableUtil.resizeColumnWidthsToFit((JTable)this.tableExif);
        ComponentUtil.forceRepaint((Component)this.tableExif);
    }

    private void initComponents() {
        this.panelTableExifFilter = new JPanel();
        this.labelTableExifFilter = new JLabel();
        this.textFieldTableExifFilter = new JTextField();
        this.scrollPaneExif = new JScrollPane();
        this.tableExif = new JTable();
        this.buttonExifToXmp = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.panelTableExifFilter.setName("panelTableExifFilter");
        this.panelTableExifFilter.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/exifmodule/Bundle");
        this.labelTableExifFilter.setText(bundle.getString("ExifPanel.labelTableExifFilter.text"));
        this.labelTableExifFilter.setName("labelTableExifFilter");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableExifFilter.add((Component)this.labelTableExifFilter, gridBagConstraints);
        this.textFieldTableExifFilter.setName("textFieldTableExifFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableExifFilter.add((Component)this.textFieldTableExifFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.panelTableExifFilter, gridBagConstraints);
        this.scrollPaneExif.setName("scrollPaneExif");
        this.tableExif.setAutoCreateRowSorter(true);
        this.tableExif.setModel((TableModel)((Object)this.exifTableModel));
        this.tableExif.setAutoResizeMode(0);
        this.tableExif.setName("tableExif");
        this.scrollPaneExif.setViewportView(this.tableExif);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPaneExif, gridBagConstraints);
        this.buttonExifToXmp.setAction(new SetExifToXmpAction());
        this.buttonExifToXmp.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_xmp.png")));
        this.buttonExifToXmp.setText(bundle.getString("ExifPanel.buttonExifToXmp.text"));
        this.buttonExifToXmp.setToolTipText(bundle.getString("ExifPanel.buttonExifToXmp.toolTipText"));
        this.buttonExifToXmp.setMargin(new Insets(2, 2, 2, 2));
        this.buttonExifToXmp.setName("buttonExifToXmp");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.add((Component)this.buttonExifToXmp, gridBagConstraints);
    }

    private static class ExifTableCellRenderer
    implements TableCellRenderer {
        private final TableLookAndFeel lookAndFeel = (TableLookAndFeel)Lookup.getDefault().lookup(TableLookAndFeel.class);
        private final JLabel cellLabel = new JLabel();

        private ExifTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String css;
            if (this.lookAndFeel == null) {
                return new JLabel(StringUtil.toStringNullToEmptyString((Object)value));
            }
            this.lookAndFeel.setTableCellColor((JComponent)this.cellLabel, isSelected);
            if (column == 0) {
                this.lookAndFeel.setTableRowHeaderFont((JComponent)this.cellLabel);
            } else {
                this.lookAndFeel.setTableCellFont((JComponent)this.cellLabel);
            }
            boolean isRowHeader = column == 0;
            int maxChars = isRowHeader ? this.lookAndFeel.getRowHeaderMaxChars() : this.lookAndFeel.getCellMaxChars();
            String string = css = isRowHeader ? this.lookAndFeel.getRowHeaderCss() : this.lookAndFeel.getCellCss();
            if (value instanceof ExifTag) {
                ExifTag exifTag = (ExifTag)value;
                if (column == 0) {
                    String displayName = exifTag.getDisplayName();
                    TableUtil.embedTableCellTextInHtml((JTable)table, (int)row, (JLabel)this.cellLabel, (String)displayName, (int)maxChars, (String)css);
                } else {
                    String displayValue = exifTag.getDisplayValue();
                    TableUtil.embedTableCellTextInHtml((JTable)table, (int)row, (JLabel)this.cellLabel, (String)displayValue, (int)maxChars, (String)css);
                }
            } else if (value instanceof Component) {
                return (Component)value;
            }
            return this.cellLabel;
        }

        public static TableStringConverter createTableStringConverter() {
            return new ExifTableStringConverter();
        }

        public static Comparator<?> createColumn0Comparator() {
            return new Column0Comparator();
        }

        public static Comparator<?> createColumn1Comparator() {
            return new Column1Comparator();
        }

        private static class ExifTableStringConverter
        extends TableStringConverter {
            private ExifTableStringConverter() {
            }

            @Override
            public String toString(TableModel model, int row, int column) {
                Object value = model.getValueAt(row, column);
                if (value instanceof ExifTag) {
                    ExifTag exifTag = (ExifTag)value;
                    return column == 0 ? exifTag.getDisplayName() : exifTag.getDisplayValue();
                }
                return StringUtil.toStringNullToEmptyString((Object)value);
            }
        }

        private static class Column1Comparator
        implements Comparator<Object> {
            private Column1Comparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof ExifTag && o2 instanceof ExifTag) {
                    ExifTag exifTag1 = (ExifTag)o1;
                    ExifTag exifTag2 = (ExifTag)o2;
                    String displayValue1 = exifTag1.getDisplayValue();
                    String displayValue2 = exifTag2.getDisplayValue();
                    return displayValue1.compareToIgnoreCase(displayValue2);
                }
                return 0;
            }
        }

        private static class Column0Comparator
        implements Comparator<Object> {
            private Column0Comparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof ExifTag && o2 instanceof ExifTag) {
                    ExifTag exifTag1 = (ExifTag)o1;
                    ExifTag exifTag2 = (ExifTag)o2;
                    String displayName1 = exifTag1.getDisplayName();
                    String displayName2 = exifTag2.getDisplayName();
                    return displayName1.compareToIgnoreCase(displayName2);
                }
                return 0;
            }
        }
    }
}

