/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exifmodule;

import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.windows.MainWindowComponent;
import org.jphototagger.api.windows.MainWindowComponentProvider;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.TabInEditWindowDisplayedEvent;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.exifmodule.ExifPanel;
import org.jphototagger.exifmodule.ModuleInstaller;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CollectionUtil;
import org.jphototagger.lib.util.ObjectUtil;
import org.openide.util.Lookup;

public final class ExifMetaDataDisplayer
implements MainWindowComponentProvider {
    private final ExifPanel exifPanel = new ExifPanel();
    private File selectedFile;
    private File displayedFile;
    private boolean exifPanelDisplayed;

    public ExifMetaDataDisplayer() {
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        List selectedFiles = evt.getSelectedFiles();
        if (selectedFiles.size() == 1) {
            this.selectedFile = (File)CollectionUtil.getFirstElement((Collection)selectedFiles);
            this.displaySelectedFile();
        } else {
            this.selectedFile = null;
            this.displayedFile = null;
            this.exifPanel.removeAllRows();
        }
    }

    @EventSubscriber(eventClass=TabInEditWindowDisplayedEvent.class)
    public void tabInEditWindowDisplayed(TabInEditWindowDisplayedEvent evt) {
        boolean isDisplayExif;
        Component selectedTabComponent = evt.getSelectedTabComponent();
        this.exifPanelDisplayed = selectedTabComponent == this.exifPanel;
        boolean bl = isDisplayExif = this.exifPanelDisplayed && this.selectedFile != null;
        if (isDisplayExif) {
            this.displaySelectedFile();
        }
    }

    private void displaySelectedFile() {
        if (this.selectedFile == null || !this.exifPanelDisplayed || ObjectUtil.equals((Object)this.selectedFile, (Object)this.displayedFile)) {
            return;
        }
        this.displayedFile = this.selectedFile;
        DisplayExifMetaData displayExifMetaData = new DisplayExifMetaData(this.selectedFile, this.exifPanel);
        EventQueueUtil.invokeInDispatchThread((Runnable)displayExifMetaData);
    }

    public Collection<? extends MainWindowComponent> getMainWindowSelectionComponents() {
        return Collections.emptyList();
    }

    public Collection<? extends MainWindowComponent> getMainWindowEditComponents() {
        return Arrays.asList(new MainWindowComponent(){

            public Component getComponent() {
                return ExifMetaDataDisplayer.this.exifPanel;
            }

            public Icon getSmallIcon() {
                return IconUtil.getImageIcon(ModuleInstaller.class, (String)"exif.png");
            }

            public Icon getLargeIcon() {
                return null;
            }

            public int getPosition() {
                return 0;
            }

            public String getTitle() {
                return Bundle.getString(ModuleInstaller.class, (String)"ExifPanel.WindowTitle", (Object[])new Object[0]);
            }

            public String getTooltipText() {
                return null;
            }

            public KeyStroke getOptionalSelectionAccelaratorKey() {
                return null;
            }
        });
    }

    public static class DisplayExifMetaData
    implements Runnable {
        private final File file;
        private final ExifPanel exifPanel;
        private static final Logger LOGGER = Logger.getLogger(DisplayExifMetaData.class.getName());

        public DisplayExifMetaData(File file, ExifPanel exifPanel) {
            this.file = file;
            this.exifPanel = exifPanel;
        }

        @Override
        public void run() {
            if (this.file == null) {
                return;
            }
            if (this.isExifPanelSelected()) {
                LOGGER.log(Level.FINEST, "Updating EXIF metadata of image file ''{0}'' in GUI table", this.file);
                WaitDisplayer waitDisplayer = (WaitDisplayer)Lookup.getDefault().lookup(WaitDisplayer.class);
                waitDisplayer.show();
                this.exifPanel.setFile(this.file);
                waitDisplayer.hide();
            }
        }

        private boolean isExifPanelSelected() {
            MainWindowManager windowManager = (MainWindowManager)Lookup.getDefault().lookup(MainWindowManager.class);
            return windowManager.isEditComponentSelected((Component)this.exifPanel);
        }
    }
}

