/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.bushe.swing.event.ContainerEventServiceFinder;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.VetoEventListener;
import org.bushe.swing.event.VetoTopicEventListener;

public class ContainerEventServiceRegistrar {
    private JComponent jComp;
    private EventSubscriber eventSubscriber;
    private VetoEventListener vetoSubscriber;
    private Class[] eventClasses;
    private EventTopicSubscriber eventTopicSubscriber;
    private VetoTopicEventListener vetoTopicSubscriber;
    private String[] topics;
    private EventService containerEventService;

    public ContainerEventServiceRegistrar(JComponent jComp) {
        this(jComp, (EventSubscriber)null, (VetoEventListener)null, (Class[])null, (EventTopicSubscriber)null, (VetoTopicEventListener)null, (String[])null);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, EventSubscriber eventSubscriber, Class ... eventClasses) {
        this(jComp, eventSubscriber, (VetoEventListener)null, eventClasses, (EventTopicSubscriber)null, (VetoTopicEventListener)null, (String[])null);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, EventTopicSubscriber eventTopicSubscriber, String ... topics) {
        this(jComp, null, null, null, eventTopicSubscriber, null, topics);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, VetoEventListener vetoSubscriber, Class ... eventClasses) {
        this(jComp, null, vetoSubscriber, eventClasses, null, null, null);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, VetoTopicEventListener vetoTopicSubscriber, String ... topics) {
        this(jComp, null, null, null, null, vetoTopicSubscriber, topics);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, EventSubscriber eventSubscriber, Class[] eventClasses, EventTopicSubscriber eventTopicSubscriber, String[] topics) {
        this(jComp, eventSubscriber, null, eventClasses, eventTopicSubscriber, null, topics);
    }

    public ContainerEventServiceRegistrar(JComponent jComp, EventSubscriber eventSubscriber, VetoEventListener vetoSubscriber, Class[] eventClasses, EventTopicSubscriber eventTopicSubscriber, VetoTopicEventListener vetoTopicSubscriber, String[] topics) {
        this.jComp = jComp;
        this.eventSubscriber = eventSubscriber;
        this.vetoSubscriber = vetoSubscriber;
        this.eventClasses = eventClasses;
        this.eventTopicSubscriber = eventTopicSubscriber;
        this.vetoTopicSubscriber = vetoTopicSubscriber;
        this.topics = topics;
        if (jComp == null) {
            throw new NullPointerException("JComponent is null");
        }
        this.updateContainerEventService();
        jComp.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }
        });
        jComp.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }

            public void componentRemoved(ContainerEvent e) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }
        });
        jComp.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }
        });
    }

    protected void updateContainerEventService() {
        String topic;
        Class eventClass;
        int i;
        if (this.containerEventService != null) {
            if (this.eventClasses != null) {
                for (i = 0; i < this.eventClasses.length; ++i) {
                    eventClass = this.eventClasses[i];
                    if (this.eventSubscriber != null) {
                        this.containerEventService.unsubscribe(eventClass, this.eventSubscriber);
                    }
                    if (this.vetoSubscriber == null) continue;
                    this.containerEventService.unsubscribeVeto(eventClass, (Object)this.vetoSubscriber);
                }
            }
            if (this.topics != null) {
                for (i = 0; i < this.topics.length; ++i) {
                    topic = this.topics[i];
                    if (this.eventTopicSubscriber != null) {
                        this.containerEventService.unsubscribe(topic, this.eventTopicSubscriber);
                    }
                    if (this.vetoTopicSubscriber == null) continue;
                    this.containerEventService.unsubscribeVeto(topic, (Object)this.vetoTopicSubscriber);
                }
            }
        }
        this.containerEventService = ContainerEventServiceFinder.getEventService(this.jComp);
        if (this.containerEventService != null) {
            if (this.eventClasses != null) {
                for (i = 0; i < this.eventClasses.length; ++i) {
                    eventClass = this.eventClasses[i];
                    if (this.eventSubscriber != null) {
                        this.containerEventService.subscribe(eventClass, this.eventSubscriber);
                    }
                    if (this.vetoSubscriber == null) continue;
                    this.containerEventService.subscribeVetoListener(eventClass, this.vetoSubscriber);
                }
            }
            if (this.topics != null) {
                for (i = 0; i < this.topics.length; ++i) {
                    topic = this.topics[i];
                    if (this.eventTopicSubscriber != null) {
                        this.containerEventService.subscribe(topic, this.eventTopicSubscriber);
                    }
                    if (this.vetoTopicSubscriber == null) continue;
                    this.containerEventService.subscribeVetoListener(topic, this.vetoTopicSubscriber);
                }
            }
        }
    }

    public EventService getContainerEventService() {
        if (this.containerEventService != null) {
            return this.containerEventService;
        }
        this.updateContainerEventService();
        return this.containerEventService;
    }
}

