/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.page;

import java.util.List;
import java.util.Map;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.DbSqlGenerator;
import jodd.db.oom.sqlgen.DbSqlBuilder;
import jodd.joy.page.PageData;
import jodd.joy.page.PageRequest;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbPager {
    protected PageRequest getDefaultPageRequest() {
        return new PageRequest();
    }

    public <T> PageData<T> page(PageRequest pageRequest, String sql, Map params, String[] sortColumns, Class[] target) {
        int pageSize;
        int page;
        PageData<T> pageData;
        if (pageRequest == null) {
            pageRequest = this.getDefaultPageRequest();
        }
        String sortColumName = null;
        boolean ascending = true;
        int sort = pageRequest.getSort();
        if (sort != 0) {
            int index;
            boolean bl = ascending = sort > 0;
            if (!ascending) {
                sort = -sort;
            }
            if ((index = sort - 1) >= sortColumns.length) {
                index = 1;
            }
            sortColumName = sortColumns[index];
        }
        if ((pageData = this.page(sql, params, page = pageRequest.getPage(), pageSize = pageRequest.getSize(), sortColumName, ascending, target)).getItems().isEmpty() && pageData.currentPage != 0 && pageData.currentPage != page) {
            int newPage = pageData.getCurrentPage();
            pageData = this.page(sql, params, newPage, pageSize, sortColumName, ascending, target);
        }
        return pageData;
    }

    protected <T> PageData<T> page(String sql, Map params, int page, int pageSize, String sortColumnName, boolean ascending, Class[] target) {
        if (sortColumnName != null) {
            sql = this.buildOrderSql(sql, sortColumnName, ascending);
        }
        int from = (page - 1) * pageSize;
        String pageSql = this.buildPageSql(sql, from, pageSize);
        DbSqlBuilder dbsql = DbSqlBuilder.sql((String)pageSql);
        DbOomQuery query = DbOomQuery.query((DbSqlGenerator)dbsql);
        query.setMaxRows(pageSize);
        query.setFetchSize(pageSize);
        query.setMap(params);
        List list = query.list(pageSize, target);
        query.close();
        String countSql = this.buildCountSql(sql);
        dbsql = DbSqlBuilder.sql((String)countSql);
        query = DbOomQuery.query((DbSqlGenerator)dbsql);
        query.setMap(params);
        long count = query.executeCount();
        query.close();
        return new PageData(page, (int)count, pageSize, list);
    }

    protected abstract String buildOrderSql(String var1, String var2, boolean var3);

    protected abstract String buildPageSql(String var1, int var2, int var3);

    protected abstract String buildCountSql(String var1);

    protected String removeSelect(String sql) {
        int ndx = StringUtil.indexOfIgnoreCase((String)sql, (String)"select");
        if (ndx != -1) {
            sql = sql.substring(ndx + 6);
        }
        return sql;
    }

    protected String removeToFrom(String sql) {
        int ndx;
        int from = 0;
        int fromCount = 1;
        int selectCount = 0;
        int lastNdx = 0;
        while ((ndx = StringUtil.indexOfIgnoreCase((String)sql, (String)"from", (int)from)) != -1) {
            String left = sql.substring(lastNdx, ndx);
            if (fromCount >= (selectCount += StringUtil.countIgnoreCase((String)left, (String)"select"))) {
                sql = sql.substring(ndx);
                break;
            }
            lastNdx = ndx;
            from = ndx + 4;
            ++fromCount;
        }
        return sql;
    }

    protected String removeLastOrderBy(String sql) {
        int ndx2;
        int ndx = StringUtil.lastIndexOfIgnoreCase((String)sql, (String)"order by");
        if (ndx != -1 && ndx > (ndx2 = sql.lastIndexOf(sql, 41))) {
            sql = sql.substring(0, ndx);
        }
        return sql;
    }
}

