/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.jspp;

import java.io.File;
import java.io.IOException;
import jodd.io.FileUtil;
import jodd.joy.jspp.JsppException;
import jodd.lagarto.EmptyTagVisitor;
import jodd.lagarto.LagartoParser;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.mutable.MutableInteger;
import jodd.util.StringUtil;

public class Jspp {
    protected char[] tagPrefix = "pp:".toCharArray();
    protected String macroExtension = ".jspf";
    protected File jsppMacroFolder;
    protected String macroPrefix = "${";
    protected String macroSuffix = "}";

    public String getTagPrefix() {
        return new String(this.tagPrefix);
    }

    public void setTagPrefix(String tagPrefix) {
        this.tagPrefix = tagPrefix.toCharArray();
    }

    public String getMacroExtension() {
        return this.macroExtension;
    }

    public void setMacroExtension(String macroExtension) {
        this.macroExtension = macroExtension;
    }

    public File getJsppMacroFolder() {
        return this.jsppMacroFolder;
    }

    public void setJsppMacroFolder(File jsppMacroFolder) {
        this.jsppMacroFolder = jsppMacroFolder;
    }

    public String getMacroPrefix() {
        return this.macroPrefix;
    }

    public void setMacroPrefix(String macroPrefix) {
        this.macroPrefix = macroPrefix;
    }

    public String getMacroSuffix() {
        return this.macroSuffix;
    }

    public void setMacroSuffix(String macroSuffix) {
        this.macroSuffix = macroSuffix;
    }

    public String process(final String input) {
        LagartoParser lagartoParser = new LagartoParser(input, true);
        final MutableInteger lastPosition = new MutableInteger(0);
        final StringBuilder sb = new StringBuilder();
        lagartoParser.parse((TagVisitor)new EmptyTagVisitor(){

            public void tag(Tag tag) {
                if (tag.getType() == TagType.SELF_CLOSING && tag.matchTagNamePrefix(Jspp.this.tagPrefix)) {
                    int tagStart = tag.getTagPosition();
                    sb.append(input.substring(lastPosition.getValue(), tagStart));
                    String tagName = tag.getName().toString();
                    tagName = tagName.substring(Jspp.this.tagPrefix.length);
                    String macroBody = Jspp.this.loadMacro(tagName);
                    int attrCount = tag.getAttributeCount();
                    for (int i = 0; i < attrCount; ++i) {
                        String key = Jspp.this.macroPrefix + tag.getAttributeName(i) + Jspp.this.macroSuffix;
                        macroBody = StringUtil.replace((String)macroBody, (String)key, (String)tag.getAttributeValue(i).toString());
                    }
                    sb.append(macroBody);
                    lastPosition.setValue(tagStart + tag.getTagLength());
                }
            }
        });
        sb.append(input.substring(lastPosition.getValue()));
        return sb.toString();
    }

    protected String loadMacro(String macroName) {
        String macroBody;
        File fileMacro = new File(this.jsppMacroFolder, macroName + this.macroExtension);
        try {
            macroBody = FileUtil.readString((File)fileMacro);
        }
        catch (IOException ioex) {
            throw new JsppException(ioex);
        }
        return macroBody;
    }
}

