/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortConverter
implements TypeConverter<Short> {
    @Override
    public Short convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Short.class) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        }
        try {
            String stringValue = value.toString().trim();
            if (StringUtil.startsWithChar(stringValue, '+')) {
                stringValue = stringValue.substring(1);
            }
            return Short.valueOf(stringValue);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

