/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.List;
import jodd.asm5.ClassVisitor;
import jodd.asm5.FieldVisitor;
import jodd.asm5.MethodVisitor;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.proxetta.asm.ProxettaClassBuilder;
import jodd.proxetta.asm.ProxettaMethodBuilder;
import jodd.proxetta.asm.ProxyAspectData;
import jodd.proxetta.asm.TargetClassInfoReader;

public class ProxettaWrapperClassBuilder
extends ProxettaClassBuilder {
    protected final Class targetClassOrInterface;
    protected final Class targetInterface;
    protected final String targetFieldName;

    public ProxettaWrapperClassBuilder(Class targetClassOrInterface, Class targetInterface, String targetFieldName, ClassVisitor dest, ProxyAspect[] aspects, String suffix, String reqProxyClassName, TargetClassInfoReader targetClassInfoReader) {
        super(dest, aspects, suffix, reqProxyClassName, targetClassInfoReader);
        this.targetClassOrInterface = targetClassOrInterface;
        this.targetInterface = targetInterface;
        this.targetFieldName = targetFieldName;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.wd.init(name, superName, this.suffix, this.reqProxyClassName);
        this.wd.superName = "java/lang/Object";
        access &= 0xFFFFFBFF;
        access &= 0xFFFFFDFF;
        if (this.targetClassOrInterface.isInterface()) {
            this.wd.wrapInterface = true;
            interfaces = new String[]{this.targetClassOrInterface.getName().replace('.', '/')};
        } else {
            this.wd.wrapInterface = false;
            if (this.targetInterface != null) {
                interfaces = new String[]{this.targetInterface.getName().replace('.', '/')};
            }
        }
        this.wd.dest.visit(version, access, this.wd.thisReference, signature, this.wd.superName, interfaces);
        this.wd.proxyAspects = new ProxyAspectData[this.aspects.length];
        for (int i = 0; i < this.aspects.length; ++i) {
            this.wd.proxyAspects[i] = new ProxyAspectData(this.wd, this.aspects[i], i);
        }
        this.wd.wrapperRef = this.targetFieldName;
        this.wd.wrapperType = 'L' + name + ';';
        FieldVisitor fv = this.wd.dest.visitField(1, this.wd.wrapperRef, this.wd.wrapperType, null, null);
        fv.visitEnd();
        this.createEmptyCtor();
    }

    protected void createEmptyCtor() {
        MethodVisitor mv = this.wd.dest.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodSignatureVisitor msign = this.targetClassInfo.lookupMethodSignatureVisitor(access, name, desc, this.wd.superReference);
        if (msign == null) {
            return null;
        }
        if (name.equals("<init>")) {
            return null;
        }
        if (name.equals("<clinit>")) {
            return null;
        }
        return this.applyProxy(msign);
    }

    protected ProxettaMethodBuilder applyProxy(MethodSignatureVisitor msign) {
        List<ProxyAspectData> aspectList = this.matchMethodPointcuts(msign);
        if (aspectList == null) {
            this.wd.proxyApplied = true;
            this.createSimpleMethodWrapper(msign);
            return null;
        }
        this.wd.proxyApplied = true;
        return new ProxettaMethodBuilder(msign, this.wd, aspectList);
    }

    protected void createSimpleMethodWrapper(MethodSignatureVisitor msign) {
        int access = msign.getAccessFlags();
        access &= 0xFFFFFBFF;
        MethodVisitor mv = this.wd.dest.visitMethod(access &= 0xFFFFFEFF, msign.getMethodName(), msign.getDescription(), msign.getRawSignature(), msign.getExceptionsArray());
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.wd.thisReference, this.wd.wrapperRef, this.wd.wrapperType);
        ProxettaAsmUtil.loadVirtualMethodArguments(mv, msign);
        if (this.wd.wrapInterface) {
            mv.visitMethodInsn(185, this.wd.wrapperType.substring(1, this.wd.wrapperType.length() - 1), msign.getMethodName(), msign.getDescription(), true);
        } else {
            mv.visitMethodInsn(182, this.wd.wrapperType.substring(1, this.wd.wrapperType.length() - 1), msign.getMethodName(), msign.getDescription(), false);
        }
        ProxettaAsmUtil.prepareReturnValue(mv, msign, 0);
        ProxettaAsmUtil.visitReturn(mv, msign, true);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void visitEnd() {
        this.makeStaticInitBlock();
        this.processSuperMethods();
        this.wd.dest.visitEnd();
    }
}

