/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.ScopedProxyAdvice;
import jodd.petite.scope.Scope;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.impl.ProxyProxetta;
import jodd.proxetta.impl.ProxyProxettaBuilder;
import jodd.proxetta.pointcuts.AllMethodsPointcut;

public class ScopedProxyManager {
    private static final Logger log = LoggerFactory.getLogger(ScopedProxyManager.class);
    protected ProxyAspect aspect = new ProxyAspect(ScopedProxyAdvice.class, new AllMethodsPointcut());
    protected Map<Class, Class> proxyClasses = new HashMap<Class, Class>();
    protected Map<String, Object> proxies = new HashMap<String, Object>();

    public ScopedProxyManager() {
        log.debug("ScopedProxyManager created");
    }

    public Object lookupValue(PetiteContainer petiteContainer, BeanDefinition targetBeanDefinition, BeanDefinition refBeanDefinition) {
        Scope targetScope = targetBeanDefinition.scope;
        Scope refBeanScope = refBeanDefinition.scope;
        boolean detectMixedScopes = petiteContainer.getConfig().isDetectMixedScopes();
        boolean wireScopedProxy = petiteContainer.getConfig().isWireScopedProxy();
        if (targetScope != null && !targetScope.accept(refBeanScope)) {
            String scopedProxyBeanName;
            Object proxy;
            if (!wireScopedProxy) {
                if (detectMixedScopes) {
                    throw new PetiteException(this.createMixingMessage(targetBeanDefinition, refBeanDefinition));
                }
                return null;
            }
            if (detectMixedScopes) {
                if (log.isWarnEnabled()) {
                    log.warn(this.createMixingMessage(targetBeanDefinition, refBeanDefinition));
                }
            } else if (log.isDebugEnabled()) {
                log.debug(this.createMixingMessage(targetBeanDefinition, refBeanDefinition));
            }
            if ((proxy = this.proxies.get(scopedProxyBeanName = refBeanDefinition.name)) == null) {
                proxy = this.createScopedProxyBean(petiteContainer, refBeanDefinition);
                this.proxies.put(scopedProxyBeanName, proxy);
            }
            return proxy;
        }
        return null;
    }

    protected String createMixingMessage(BeanDefinition targetBeanDefinition, BeanDefinition refBeanDefinition) {
        return "Scopes mixing detected: " + refBeanDefinition.name + "@" + refBeanDefinition.scope.getClass().getSimpleName() + " -> " + targetBeanDefinition.name + "@" + targetBeanDefinition.scope.getClass().getSimpleName();
    }

    protected Object createScopedProxyBean(PetiteContainer petiteContainer, BeanDefinition refBeanDefinition) {
        Object proxy;
        Class beanType = refBeanDefinition.type;
        Class proxyClass = this.proxyClasses.get(beanType);
        if (proxyClass == null) {
            ProxyProxetta proxetta = ProxyProxetta.withAspects(this.aspect);
            proxetta.setClassNameSuffix("$ScopedProxy");
            proxetta.setVariableClassName(true);
            ProxyProxettaBuilder builder = proxetta.builder(beanType);
            proxyClass = builder.define();
            this.proxyClasses.put(beanType, proxyClass);
        }
        try {
            proxy = proxyClass.newInstance();
            Field field = proxyClass.getField("$__petiteContainer$0");
            field.set(proxy, petiteContainer);
            field = proxyClass.getField("$__name$0");
            field.set(proxy, refBeanDefinition.name);
        }
        catch (Exception ex) {
            throw new PetiteException(ex);
        }
        return proxy;
    }
}

