/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.macro;

import jodd.madvoc.macro.PathMacros;
import jodd.util.StringUtil;

public abstract class BasePathMacros
implements PathMacros {
    protected int macrosCount;
    protected String[] names;
    protected String[] patterns;
    protected String[] fixed;

    public boolean init(String actionPath, String[] separators) {
        int[] ndx;
        String prefix = separators[0];
        String split = separators[1];
        String suffix = separators[2];
        this.macrosCount = StringUtil.count(actionPath, prefix);
        if (this.macrosCount == 0) {
            return false;
        }
        this.names = new String[this.macrosCount];
        this.patterns = new String[this.macrosCount];
        this.fixed = new String[this.macrosCount + 1];
        int offset = 0;
        int i = 0;
        while ((ndx = StringUtil.indexOfRegion(actionPath, prefix, suffix, offset)) != null) {
            this.fixed[i] = actionPath.substring(offset, ndx[0]);
            String name = actionPath.substring(ndx[1], ndx[2]);
            String pattern = null;
            int colonNdx = name.indexOf(split);
            if (colonNdx != -1) {
                pattern = name.substring(colonNdx + 1).trim();
                name = name.substring(0, colonNdx).trim();
            }
            this.patterns[i] = pattern;
            this.names[i] = name;
            offset = ndx[3];
            ++i;
        }
        this.fixed[i] = offset < actionPath.length() ? actionPath.substring(offset) : "";
        return true;
    }

    public String[] getNames() {
        return this.names;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public int getMacrosCount() {
        return this.macrosCount;
    }

    public int match(String actionPath) {
        String[] values = this.process(actionPath, true);
        if (values == null) {
            return -1;
        }
        int macroChars = 0;
        for (String value : values) {
            if (value == null) continue;
            macroChars += value.length();
        }
        return actionPath.length() - macroChars;
    }

    protected abstract boolean matchValue(int var1, String var2);

    public String[] extract(String actionPath) {
        return this.process(actionPath, false);
    }

    private String[] process(String actionPath, boolean match) {
        if (match && !actionPath.startsWith(this.fixed[0])) {
            return null;
        }
        String[] values = new String[this.macrosCount];
        int offset = this.fixed[0].length();
        int i = 0;
        while (i < this.macrosCount) {
            String macroValue;
            String nextFixed;
            int nexti = i;
            do {
                if (++nexti <= this.macrosCount) continue;
                nextFixed = null;
                break;
            } while ((nextFixed = this.fixed[nexti]).length() == 0);
            int ndx = nextFixed != null ? actionPath.indexOf(nextFixed, offset) : actionPath.length();
            if (ndx == -1) {
                return null;
            }
            values[i] = macroValue = actionPath.substring(offset, ndx);
            if (match && this.patterns[i] != null && !this.matchValue(i, macroValue)) {
                return null;
            }
            if (nextFixed == null) {
                offset = ndx;
                break;
            }
            int nextFixedLength = nextFixed.length();
            offset = ndx + nextFixedLength;
            i = nexti;
        }
        if (offset != actionPath.length()) {
            return null;
        }
        return values;
    }
}

