/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.injector.BaseScopeInjector;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Outjector;
import jodd.madvoc.injector.Target;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.MultipartRequestWrapper;
import jodd.upload.FileUpload;
import jodd.util.StringUtil;

public class RequestScopeInjector
extends BaseScopeInjector
implements Injector,
Outjector {
    protected final String encoding;
    protected final String attributeMoveId;
    protected boolean ignoreEmptyRequestParams;
    protected boolean treatEmptyParamsAsNull;
    protected boolean injectAttributes = true;
    protected boolean injectParameters = true;
    protected boolean trimParams;
    protected boolean encodeGetParams;
    protected boolean ignoreInvalidUploadFiles = true;

    public RequestScopeInjector(MadvocConfig madvocConfig, ScopeDataResolver scopeDataResolver) {
        super(ScopeType.REQUEST, scopeDataResolver);
        this.encoding = madvocConfig.getEncoding();
        this.attributeMoveId = madvocConfig.getAttributeMoveId();
        this.silent = true;
    }

    public boolean isIgnoreEmptyRequestParams() {
        return this.ignoreEmptyRequestParams;
    }

    public void setIgnoreEmptyRequestParams(boolean ignoreEmptyRequestParams) {
        this.ignoreEmptyRequestParams = ignoreEmptyRequestParams;
    }

    public boolean isTreatEmptyParamsAsNull() {
        return this.treatEmptyParamsAsNull;
    }

    public void setTreatEmptyParamsAsNull(boolean treatEmptyParamsAsNull) {
        this.treatEmptyParamsAsNull = treatEmptyParamsAsNull;
    }

    public boolean isInjectAttributes() {
        return this.injectAttributes;
    }

    public void setInjectAttributes(boolean injectAttributes) {
        this.injectAttributes = injectAttributes;
    }

    public boolean isInjectParameters() {
        return this.injectParameters;
    }

    public void setInjectParameters(boolean injectParameters) {
        this.injectParameters = injectParameters;
    }

    public boolean isTrimParams() {
        return this.trimParams;
    }

    public void setTrimParams(boolean trimParams) {
        this.trimParams = trimParams;
    }

    public boolean isEncodeGetParams() {
        return this.encodeGetParams;
    }

    public void setEncodeGetParams(boolean encodeGetParams) {
        this.encodeGetParams = encodeGetParams;
    }

    public boolean isIgnoreInvalidUploadFiles() {
        return this.ignoreInvalidUploadFiles;
    }

    public void setIgnoreInvalidUploadFiles(boolean ignoreInvalidUploadFiles) {
        this.ignoreInvalidUploadFiles = ignoreInvalidUploadFiles;
    }

    protected void injectAttributes(Target[] targets, ScopeData[] injectData, HttpServletRequest servletRequest) {
        Enumeration attributeNames = servletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            for (int i = 0; i < targets.length; ++i) {
                ScopeData.In[] scopes;
                Target target = targets[i];
                if (injectData[i] == null || (scopes = injectData[i].in) == null) continue;
                for (ScopeData.In in : scopes) {
                    String name = this.getMatchedPropertyName(in, attrName);
                    if (name == null) continue;
                    Object attrValue = servletRequest.getAttribute(attrName);
                    this.setTargetProperty(target, name, attrValue);
                }
            }
        }
    }

    protected void injectParameters(Target[] targets, ScopeData[] injectData, HttpServletRequest servletRequest) {
        boolean encode = this.encodeGetParams && servletRequest.getMethod().equals("GET");
        Enumeration paramNames = servletRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            for (int i = 0; i < targets.length; ++i) {
                ScopeData.In[] scopes;
                Target target = targets[i];
                if (injectData[i] == null || (scopes = injectData[i].in) == null) continue;
                for (ScopeData.In in : scopes) {
                    String name = this.getMatchedPropertyName(in, paramName);
                    if (name == null) continue;
                    String[] paramValues = servletRequest.getParameterValues(paramName);
                    if ((paramValues = ServletUtil.prepareParameters(paramValues, this.trimParams, this.treatEmptyParamsAsNull, this.ignoreEmptyRequestParams)) == null) continue;
                    if (encode) {
                        for (int j = 0; j < paramValues.length; ++j) {
                            String p = paramValues[j];
                            if (p == null) continue;
                            paramValues[j] = StringUtil.convertCharset(p, "ISO-8859-1", this.encoding);
                        }
                    }
                    String[] value = paramValues.length != 1 ? paramValues : paramValues[0];
                    this.setTargetProperty(target, name, value);
                }
            }
        }
    }

    protected void injectUploadedFiles(Target[] targets, ScopeData[] injectData, HttpServletRequest servletRequest) {
        if (!(servletRequest instanceof MultipartRequestWrapper)) {
            return;
        }
        MultipartRequestWrapper multipartRequest = (MultipartRequestWrapper)servletRequest;
        if (!multipartRequest.isMultipart()) {
            return;
        }
        Enumeration<String> paramNames = multipartRequest.getFileParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            for (int i = 0; i < targets.length; ++i) {
                ScopeData.In[] scopes;
                Target target = targets[i];
                if (injectData[i] == null || (scopes = injectData[i].in) == null) continue;
                for (ScopeData.In in : scopes) {
                    String name = this.getMatchedPropertyName(in, paramName);
                    if (name == null) continue;
                    FileUpload[] paramValues = multipartRequest.getFiles(paramName);
                    if (this.ignoreInvalidUploadFiles) {
                        for (int j = 0; j < paramValues.length; ++j) {
                            FileUpload paramValue = paramValues[j];
                            if (paramValue.isValid() && paramValue.isUploaded()) continue;
                            paramValues[j] = null;
                        }
                    }
                    FileUpload[] value = paramValues.length == 1 ? paramValues[0] : paramValues;
                    this.setTargetProperty(target, name, value);
                }
            }
        }
    }

    protected void outjectMoveSource(ActionRequest actionRequest) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        String moveId = servletRequest.getParameter(this.attributeMoveId);
        if (moveId != null) {
            HttpSession session = servletRequest.getSession();
            ActionRequest sourceRequest = (ActionRequest)session.getAttribute(moveId);
            session.removeAttribute(moveId);
            if (sourceRequest != null) {
                this.outjectAfterMove(sourceRequest);
            }
        }
    }

    public void prepare(ActionRequest actionRequest) {
        this.outjectMoveSource(actionRequest);
    }

    public void inject(ActionRequest actionRequest) {
        Target[] targets = actionRequest.getTargets();
        ScopeData[] injectData = this.lookupScopeData(actionRequest);
        if (injectData == null) {
            return;
        }
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        if (this.injectAttributes) {
            this.injectAttributes(targets, injectData, servletRequest);
        }
        if (this.injectParameters) {
            this.injectParameters(targets, injectData, servletRequest);
            this.injectUploadedFiles(targets, injectData, servletRequest);
        }
    }

    public void outject(ActionRequest actionRequest) {
        ScopeData[] outjectData = this.lookupScopeData(actionRequest);
        if (outjectData == null) {
            return;
        }
        Target[] targets = actionRequest.getTargets();
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        for (int i = 0; i < targets.length; ++i) {
            ScopeData.Out[] scopes;
            Target target = targets[i];
            if (outjectData[i] == null || (scopes = outjectData[i].out) == null) continue;
            for (ScopeData.Out out : scopes) {
                Object value = this.getTargetProperty(target, out);
                servletRequest.setAttribute(out.name, value);
            }
        }
    }

    protected void outjectAfterMove(ActionRequest sourceRequest) {
        ScopeData[] outjectData = this.lookupScopeData(sourceRequest);
        if (outjectData == null) {
            return;
        }
        Target[] targets = sourceRequest.getTargets();
        HttpServletRequest servletRequest = sourceRequest.getHttpServletRequest();
        for (int i = 0; i < targets.length; ++i) {
            ScopeData.Out[] scopes;
            Target target = targets[i];
            if (outjectData[i] == null || (scopes = outjectData[i].out) == null) continue;
            for (ScopeData.Out out : scopes) {
                Object value = this.getTargetProperty(target, out);
                servletRequest.setAttribute(out.name, value);
            }
        }
    }
}

