/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import java.lang.reflect.Method;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionDef;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.config.MadvocConfigurator;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.util.ArraysUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManualMadvocConfigurator
implements MadvocConfigurator {
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected ActionMethodParser actionMethodParser;
    @PetiteInject
    protected ResultsManager resultsManager;
    @PetiteInject
    protected FiltersManager filtersManager;
    @PetiteInject
    protected InterceptorsManager interceptorsManager;

    public void result(Class<? extends ActionResult> resultClass) {
        this.resultsManager.register(resultClass);
    }

    public <T extends ActionInterceptor> T interceptor(Class<T> actionInterceptorClass) {
        return (T)((ActionInterceptor)this.interceptorsManager.resolve(actionInterceptorClass));
    }

    public <T extends ActionFilter> T filter(Class<T> actionFilterClass) {
        return (T)((ActionFilter)this.filtersManager.resolve(actionFilterClass));
    }

    public ActionBuilder action() {
        return new ActionBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ActionBuilder {
        String method;
        String actionPath;
        Class actionClass;
        Class<? extends ActionResult> actionResult;
        Method actionClassMethod;
        String actionMethodString;
        String alias;
        String resultBasePath;
        Class<? extends ActionFilter>[] actionFilters;
        Class<? extends ActionInterceptor>[] actionInterceptors;
        boolean async;

        public ActionBuilder path(String path) {
            this.actionPath = path;
            return this;
        }

        public ActionBuilder httpMethod(String method) {
            this.method = method;
            return this;
        }

        public ActionBuilder path(String method, String path) {
            this.method = method;
            return this.path(path);
        }

        public ActionBuilder mapTo(Class actionClass, Method actionMethod) {
            this.actionClass = actionClass;
            this.actionClassMethod = actionMethod;
            this.actionMethodString = null;
            return this;
        }

        public ActionBuilder mapTo(Method actionMethod) {
            this.actionClass = actionMethod.getDeclaringClass();
            this.actionClassMethod = actionMethod;
            this.actionMethodString = null;
            return this;
        }

        public ActionBuilder mapTo(Class actionClass, String actionMethodName) {
            this.actionClass = actionClass;
            this.actionClassMethod = null;
            this.actionMethodString = actionMethodName;
            return this;
        }

        public ActionBuilder interceptBy(Class<? extends ActionInterceptor> ... interceptors) {
            this.actionInterceptors = this.actionInterceptors == null ? interceptors : ArraysUtil.join(this.actionInterceptors, interceptors);
            return this;
        }

        public ActionBuilder interceptBy(Class<? extends ActionInterceptor> interceptor) {
            this.actionInterceptors = this.actionInterceptors == null ? new Class[]{interceptor} : ArraysUtil.append(this.actionInterceptors, interceptor);
            return this;
        }

        public ActionBuilder filterBy(Class<? extends ActionFilter> ... filters) {
            this.actionFilters = this.actionFilters == null ? filters : ArraysUtil.join(this.actionFilters, filters);
            return this;
        }

        public ActionBuilder filterBy(Class<? extends ActionFilter> filter) {
            this.actionFilters = this.actionFilters == null ? new Class[]{filter} : ArraysUtil.append(this.actionFilters, filter);
            return this;
        }

        public ActionBuilder alias(String aliasPath) {
            this.alias = aliasPath;
            return this;
        }

        public ActionBuilder renderWith(Class<? extends ActionResult> actionResult) {
            this.actionResult = actionResult;
            return this;
        }

        public ActionBuilder async(boolean async) {
            this.async = async;
            return this;
        }

        public ActionBuilder resultBase(String resultBasePath) {
            this.resultBasePath = resultBasePath;
            return this;
        }

        public void bind() {
            if (this.actionMethodString != null) {
                this.actionClassMethod = ManualMadvocConfigurator.this.actionsManager.resolveActionMethod(this.actionClass, this.actionMethodString);
            }
            ActionFilter[] actionFilterInstances = (ActionFilter[])ManualMadvocConfigurator.this.filtersManager.resolveAll(this.actionFilters);
            ActionInterceptor[] actionInterceptorInstances = (ActionInterceptor[])ManualMadvocConfigurator.this.interceptorsManager.resolveAll(this.actionInterceptors);
            ActionDef actionDef = this.resultBasePath != null ? new ActionDef(this.actionPath, this.method, this.resultBasePath) : new ActionDef(this.actionPath, this.method);
            ActionConfig actionConfig = ManualMadvocConfigurator.this.actionMethodParser.createActionConfig(this.actionClass, this.actionClassMethod, this.actionResult, actionFilterInstances, actionInterceptorInstances, actionDef, this.async);
            ManualMadvocConfigurator.this.actionsManager.registerAction(actionConfig);
            if (this.alias != null) {
                ManualMadvocConfigurator.this.actionsManager.registerPathAlias(this.alias, this.actionPath);
            }
        }

        public boolean isSet() {
            return this.actionPath != null && this.actionMethodString != null;
        }
    }
}

