/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jodd.servlet.wrapper.ContentTypeHeaderResolver;

public class MadvocResponseWrapper
extends HttpServletResponseWrapper {
    protected static final String CONTENT_TYPE = "content-type";
    protected String mimeType;
    protected String characterEncoding;

    public MadvocResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void setHeader(String name, String value) {
        if (name.toLowerCase().equals(CONTENT_TYPE)) {
            this.setContentType(value);
        } else {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name.toLowerCase().equals(CONTENT_TYPE)) {
            this.setContentType(value);
        } else {
            super.addHeader(name, value);
        }
    }

    public void setContentType(String type) {
        if (type == null) {
            this.mimeType = null;
            this.characterEncoding = null;
            return;
        }
        ContentTypeHeaderResolver contentTypeResolver = new ContentTypeHeaderResolver(type);
        this.mimeType = contentTypeResolver.getMimeType();
        this.characterEncoding = contentTypeResolver.getEncoding();
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
    }

    private void applyContentType() {
        if (this.mimeType != null) {
            super.setContentType(this.mimeType);
            if (this.characterEncoding != null) {
                super.setCharacterEncoding(this.characterEncoding);
            }
        }
    }

    public String getContentType() {
        String contentType = this.mimeType;
        if (this.mimeType != null && this.characterEncoding != null) {
            contentType = contentType + ";charset=" + this.characterEncoding;
        }
        return contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.applyContentType();
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        this.applyContentType();
        return super.getWriter();
    }
}

