/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.madvoc.ActionConfigSet;
import jodd.madvoc.ActionDef;
import jodd.madvoc.ScopeData;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.Result;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionConfig {
    public final Class actionClass;
    public final Method actionClassMethod;
    public final Class<? extends ActionResult> actionResult;
    public final String actionPath;
    public final String actionMethod;
    public final String resultBasePath;
    public final Field resultField;
    public final boolean async;
    public final ScopeData[][] scopeData;
    public final MethodParam[] methodParams;
    public final boolean hasArguments;
    protected ActionConfigSet actionConfigSet;
    public final ActionFilter[] filters;
    public final ActionInterceptor[] interceptors;

    public ActionConfig(Class actionClass, Method actionClassMethod, ActionFilter[] filters, ActionInterceptor[] interceptors, ActionDef actionDef, Class<? extends ActionResult> actionResult, boolean async, ScopeData[][] scopeData, MethodParam[] methodParams) {
        this.actionClass = actionClass;
        this.actionClassMethod = actionClassMethod;
        this.actionPath = actionDef.getActionPath();
        this.actionMethod = actionDef.getActionMethod() == null ? null : actionDef.getActionMethod().toUpperCase();
        this.resultBasePath = actionDef.getResultBasePath();
        this.hasArguments = actionClassMethod.getParameterTypes().length != 0;
        this.actionResult = actionResult;
        this.async = async;
        this.scopeData = scopeData;
        this.filters = filters;
        this.interceptors = interceptors;
        this.methodParams = methodParams;
        this.resultField = this.findResultField(actionClass);
    }

    protected Field findResultField(Class actionClass) {
        FieldDescriptor[] fields;
        for (FieldDescriptor fd : fields = ClassIntrospector.lookup(actionClass).getAllFieldDescriptors()) {
            Field field = fd.getField();
            if (!ReflectUtil.isTypeOf(field.getType(), Result.class)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    public Class getActionClass() {
        return this.actionClass;
    }

    public Method getActionClassMethod() {
        return this.actionClassMethod;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public String getActionMethod() {
        return this.actionMethod;
    }

    public String getResultBasePath() {
        return this.resultBasePath;
    }

    public ActionInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public boolean isAsync() {
        return this.async;
    }

    public ActionConfigSet getActionConfigSet() {
        return this.actionConfigSet;
    }

    public MethodParam[] getMethodParams() {
        return this.methodParams;
    }

    public Class<? extends ActionResult> getActionResult() {
        return this.actionResult;
    }

    public String getActionString() {
        String className = this.actionClass.getName();
        int ndx = className.indexOf("$$");
        if (ndx != -1) {
            className = className.substring(0, ndx);
        }
        return className + '#' + this.actionClassMethod.getName();
    }

    public String toString() {
        return "action: " + this.actionPath + (this.actionMethod == null ? "" : '#' + this.actionMethod) + "  -->  " + this.getActionString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodParam {
        private final Class type;
        private final String name;
        private final Class<? extends Annotation> annotationType;

        public MethodParam(Class type, String name, Class<? extends Annotation> annotationType) {
            this.type = type;
            this.name = name;
            this.annotationType = annotationType;
        }

        public Class getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends Annotation> getAnnotationType() {
            return this.annotationType;
        }
    }
}

