/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.LagartoDOMException;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeVisitor;
import jodd.util.HtmlDecoder;
import jodd.util.HtmlEncoder;
import jodd.util.StringUtil;

public class Text
extends Node {
    protected String encodedText;
    protected Boolean blank;

    public Text(Document ownerDocument, String text) {
        super(ownerDocument, Node.NodeType.TEXT, null);
        this.nodeValue = text;
        this.encodedText = null;
    }

    public Text clone() {
        return this.cloneTo(new Text(this.ownerDocument, this.nodeValue));
    }

    public boolean isBlank() {
        if (this.blank == null) {
            this.blank = StringUtil.isBlank(this.nodeValue);
        }
        return this.blank;
    }

    public void setNodeValue(String value) {
        this.encodedText = null;
        super.setNodeValue(value);
    }

    public void setTextContent(String text) {
        this.encodedText = text;
        this.nodeValue = HtmlDecoder.decode(text);
    }

    public String getTextContent() {
        if (this.encodedText == null) {
            this.encodedText = HtmlEncoder.text(this.nodeValue);
        }
        return this.encodedText;
    }

    public void appendTextContent(Appendable appendable) {
        try {
            appendable.append(this.getTextContent());
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
    }

    protected void visitNode(NodeVisitor nodeVisitor) {
        nodeVisitor.text(this);
    }
}

