/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedList;
import jodd.http.HttpProgressListener;
import jodd.http.up.Uploadable;
import jodd.io.StreamUtil;
import jodd.util.buffer.FastByteBuffer;

public class Buffer {
    protected LinkedList<Object> list = new LinkedList();
    protected FastByteBuffer last;
    protected int size;

    public Buffer append(String string) {
        this.ensureLast();
        try {
            byte[] bytes = string.getBytes("ISO-8859-1");
            this.last.append(bytes);
            this.size += bytes.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    public Buffer append(char c) {
        this.append(Character.toString(c));
        return this;
    }

    public Buffer append(int number) {
        this.append(Integer.toString(number));
        return this;
    }

    public Buffer append(Uploadable uploadable) {
        this.list.add(uploadable);
        this.size += uploadable.getSize();
        this.last = null;
        return this;
    }

    public Buffer append(Buffer buffer) {
        if (buffer.list.size() == 0) {
            return buffer;
        }
        this.list.addAll(buffer.list);
        this.last = buffer.last;
        this.size += buffer.size;
        return this;
    }

    public int size() {
        return this.size;
    }

    private void ensureLast() {
        if (this.last == null) {
            this.last = new FastByteBuffer();
            this.list.add(this.last);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        for (Object e : this.list) {
            if (e instanceof FastByteBuffer) {
                FastByteBuffer fastByteBuffer = (FastByteBuffer)e;
                byte[] array = fastByteBuffer.toArray();
                writer.write(new String(array, "ISO-8859-1"));
                continue;
            }
            if (!(e instanceof Uploadable)) continue;
            Uploadable uploadable = (Uploadable)e;
            InputStream inputStream = uploadable.openInputStream();
            try {
                StreamUtil.copy(inputStream, writer, "ISO-8859-1");
            }
            finally {
                StreamUtil.close(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        for (Object e : this.list) {
            if (e instanceof FastByteBuffer) {
                FastByteBuffer fastByteBuffer = (FastByteBuffer)e;
                out.write(fastByteBuffer.toArray());
                continue;
            }
            if (!(e instanceof Uploadable)) continue;
            Uploadable uploadable = (Uploadable)e;
            InputStream inputStream = uploadable.openInputStream();
            try {
                StreamUtil.copy(inputStream, out);
            }
            finally {
                StreamUtil.close(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, HttpProgressListener progressListener) throws IOException {
        int size = this.size();
        int callbackSize = progressListener.callbackSize(size);
        int count = 0;
        int step = 0;
        progressListener.transferred(count);
        for (Object e : this.list) {
            int chunk;
            if (e instanceof FastByteBuffer) {
                FastByteBuffer fastByteBuffer = (FastByteBuffer)e;
                byte[] bytes = fastByteBuffer.toArray();
                int offset = 0;
                while (offset < bytes.length) {
                    chunk = callbackSize - step;
                    if (offset + chunk > bytes.length) {
                        chunk = bytes.length - offset;
                    }
                    out.write(bytes, offset, chunk);
                    offset += chunk;
                    count += chunk;
                    if ((step += chunk) < callbackSize) continue;
                    progressListener.transferred(count);
                    step -= callbackSize;
                }
                continue;
            }
            if (!(e instanceof Uploadable)) continue;
            Uploadable uploadable = (Uploadable)e;
            InputStream inputStream = uploadable.openInputStream();
            int remaining = uploadable.getSize();
            try {
                while (remaining > 0) {
                    chunk = callbackSize - step;
                    if (chunk > remaining) {
                        chunk = remaining;
                    }
                    StreamUtil.copy(inputStream, out, chunk);
                    remaining -= chunk;
                    count += chunk;
                    if ((step += chunk) < callbackSize) continue;
                    progressListener.transferred(count);
                    step -= callbackSize;
                }
            }
            finally {
                StreamUtil.close(inputStream);
            }
        }
        if (step != 0) {
            progressListener.transferred(count);
        }
    }
}

