/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.sqlgen.DbSqlBuilderException;
import jodd.db.oom.sqlgen.chunks.SqlChunk;

public class ReferenceChunk
extends SqlChunk {
    protected final String tableRef;
    protected final String columnRef;
    protected final boolean onlyId;

    public ReferenceChunk(String tableRef, String columnRef) {
        this(tableRef, columnRef, false);
    }

    public ReferenceChunk(String tableRef, String columnRef, boolean onlyId) {
        super(3);
        this.tableRef = tableRef;
        this.columnRef = columnRef;
        this.onlyId = onlyId;
    }

    public ReferenceChunk(String reference) {
        super(3);
        int dotNdx = reference.indexOf(46);
        if (dotNdx == -1) {
            this.tableRef = reference;
            this.columnRef = null;
            this.onlyId = false;
        } else {
            String ref = reference.substring(0, dotNdx);
            if (ref.length() == 0) {
                ref = null;
            }
            this.tableRef = ref;
            ref = reference.substring(dotNdx + 1);
            if (ref.length() == 0) {
                ref = null;
            }
            this.columnRef = ref;
            this.onlyId = this.columnRef != null && this.columnRef.equals("+");
        }
    }

    public void process(StringBuilder out) {
        DbEntityDescriptor ded;
        if (this.tableRef != null) {
            ded = this.lookupTableRef(this.tableRef);
            String tableName = this.resolveTable(this.tableRef, ded);
            out.append(tableName);
        } else {
            ded = this.findColumnRef(this.columnRef);
        }
        if (this.onlyId) {
            if (this.tableRef != null) {
                out.append('.');
            }
            out.append(ded.getIdColumnName());
        } else if (this.columnRef != null) {
            String column;
            DbEntityColumnDescriptor dec;
            this.templateData.lastColumnDec = dec = ded.findByPropertyName(this.columnRef);
            String string = column = dec == null ? null : dec.getColumnName();
            if (column == null) {
                throw new DbSqlBuilderException("Invalid column reference: " + this.tableRef + '.' + this.columnRef);
            }
            if (this.tableRef != null) {
                out.append('.');
            }
            out.append(column);
        }
    }
}

