/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jodd.db.DbManager;
import jodd.db.DbQueryParser;
import jodd.db.DbSession;
import jodd.db.DbSessionProvider;
import jodd.db.DbSqlException;
import jodd.db.DbUtil;
import jodd.db.QueryMapper;
import jodd.db.debug.LoggablePreparedStatementFactory;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DbQueryBase {
    private static final Logger log = LoggerFactory.getLogger(DbQueryBase.class);
    protected final DbManager dbManager = DbManager.getInstance();
    public static final int QUERY_CREATED = 1;
    public static final int QUERY_INITIALIZED = 2;
    public static final int QUERY_CLOSED = 3;
    protected int queryState = 1;
    protected Connection connection;
    protected DbSession session;
    protected String sqlString;
    protected Statement statement;
    protected PreparedStatement preparedStatement;
    protected Set<ResultSet> resultSets;
    protected DbQueryParser query;
    protected boolean forcePreparedStatement;
    protected boolean autoClose;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    protected int type;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    protected int concurrencyType;
    public static final int DEFAULT_HOLDABILITY = -1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    protected int holdability;
    protected boolean debug;
    protected String[] generatedColumns;
    protected int fetchSize;
    protected int maxRows;
    protected long start;
    protected long elapsed = -1L;
    protected static int totalOpenResultSetCount;

    protected DbQueryBase() {
        this.forcePreparedStatement = this.dbManager.forcePreparedStatement;
        this.type = this.dbManager.type;
        this.concurrencyType = this.dbManager.concurrencyType;
        this.holdability = this.dbManager.holdability;
        this.debug = this.dbManager.debug;
        this.fetchSize = this.dbManager.fetchSize;
        this.maxRows = this.dbManager.maxRows;
    }

    public int getQueryState() {
        return this.queryState;
    }

    protected void checkNotClosed() {
        if (this.queryState == 3) {
            throw new DbSqlException(this, "Query is closed. Operation may be performed only on active queries.");
        }
    }

    protected void checkCreated() {
        if (this.queryState != 1) {
            String message = this.queryState == 2 ? "Query is already initialized." : "Query is closed.";
            throw new DbSqlException(this, message + " Operation may be performed only on created queries.");
        }
    }

    protected void checkInitialized() {
        if (this.queryState != 2) {
            String message = this.queryState == 1 ? "Query is created but not yet initialized." : "Query is closed.";
            throw new DbSqlException(this, message + " Operation may be performed only on initialized queries.");
        }
    }

    public boolean isClosed() {
        return this.queryState == 3;
    }

    public boolean isActive() {
        return this.queryState < 3;
    }

    public boolean isInitialized() {
        return this.queryState == 2;
    }

    public DbSession getSession() {
        return this.session;
    }

    protected void saveResultSet(ResultSet rs) {
        if (this.resultSets == null) {
            this.resultSets = new HashSet<ResultSet>();
        }
        this.resultSets.add(rs);
    }

    public void forcePreparedStatement() {
        this.checkCreated();
        this.forcePreparedStatement = true;
    }

    public final void init() {
        this.checkNotClosed();
        if (this.queryState == 2) {
            return;
        }
        this.initializeJdbc();
        this.queryState = 2;
        this.prepareQuery();
    }

    protected void initSession(DbSession session) {
        if (session != null) {
            this.session = session;
            return;
        }
        DbSessionProvider dbSessionProvider = this.dbManager.sessionProvider;
        if (dbSessionProvider == null) {
            throw new DbSqlException("Session provider not available.");
        }
        this.session = dbSessionProvider.getDbSession();
    }

    protected void initializeJdbc() {
        if (this.connection == null) {
            this.initSession(this.session);
            this.connection = this.session.getConnection();
        }
        this.query = new DbQueryParser(this.sqlString);
        if (!this.forcePreparedStatement && !this.query.prepared) {
            try {
                this.statement = this.holdability != -1 ? this.connection.createStatement(this.type, this.concurrencyType, this.holdability) : this.connection.createStatement(this.type, this.concurrencyType);
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Create statement error", sex);
            }
            return;
        }
        try {
            this.statement = this.debug ? (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? LoggablePreparedStatementFactory.create(this.connection, this.query.sql, 1) : LoggablePreparedStatementFactory.create(this.connection, this.query.sql, this.generatedColumns)) : (this.holdability != -1 ? LoggablePreparedStatementFactory.create(this.connection, this.query.sql, this.type, this.concurrencyType, this.holdability) : LoggablePreparedStatementFactory.create(this.connection, this.query.sql, this.type, this.concurrencyType))) : (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? this.connection.prepareStatement(this.query.sql, 1) : this.connection.prepareStatement(this.query.sql, this.generatedColumns)) : (this.holdability != -1 ? this.connection.prepareStatement(this.query.sql, this.type, this.concurrencyType, this.holdability) : this.connection.prepareStatement(this.query.sql, this.type, this.concurrencyType)));
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Create prepared statement error", sex);
        }
        this.preparedStatement = (PreparedStatement)this.statement;
    }

    protected void prepareQuery() {
        if (this.fetchSize != 0) {
            this.setFetchSize(this.fetchSize);
        }
        if (this.maxRows != 0) {
            this.setMaxRows(this.maxRows);
        }
    }

    public <Q extends DbQueryBase> Q autoClose() {
        this.autoClose = true;
        return (Q)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLException closeQueryResultSets() {
        SQLException sqlException = null;
        if (this.resultSets != null) {
            for (ResultSet rs : this.resultSets) {
                try {
                    rs.close();
                }
                catch (SQLException sex) {
                    if (sqlException == null) {
                        sqlException = sex;
                        continue;
                    }
                    sqlException.setNextException(sex);
                }
                finally {
                    --totalOpenResultSetCount;
                }
            }
            this.resultSets.clear();
            this.resultSets = null;
        }
        return sqlException;
    }

    public void closeAllResultSets() {
        SQLException sex = this.closeQueryResultSets();
        if (sex != null) {
            throw new DbSqlException("Close associated ResultSets error", sex);
        }
    }

    protected SQLException closeQuery() {
        SQLException sqlException = this.closeQueryResultSets();
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sex) {
                if (sqlException == null) {
                    sqlException = sex;
                }
                sqlException.setNextException(sex);
            }
            this.statement = null;
        }
        this.query = null;
        this.queryState = 3;
        return sqlException;
    }

    public void close() {
        SQLException sqlException = this.closeQuery();
        this.connection = null;
        if (this.session != null) {
            this.session.detachQuery(this);
        }
        if (sqlException != null) {
            throw new DbSqlException("Close query error", sqlException);
        }
    }

    public void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        if (!this.resultSets.remove(rs)) {
            throw new DbSqlException(this, "ResultSet is not created by this query");
        }
        try {
            rs.close();
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Close result set error", sex);
        }
        finally {
            --totalOpenResultSetCount;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.checkCreated();
        this.type = type;
    }

    public void typeForwardOnly() {
        this.setType(1003);
    }

    public void typeScrollSensitive() {
        this.setType(1005);
    }

    public void typeScrollInsensitive() {
        this.setType(1005);
    }

    public int getConcurrencyType() {
        return this.concurrencyType;
    }

    public void setConcurrencyType(int concurrencyType) {
        this.checkCreated();
        this.concurrencyType = concurrencyType;
    }

    public void concurReadOnly() {
        this.setConcurrencyType(1007);
    }

    public void concurUpdatable() {
        this.setConcurrencyType(1008);
    }

    public int getHoldability() {
        return this.holdability;
    }

    public void setHoldability(int holdability) {
        this.checkCreated();
        this.holdability = holdability;
    }

    public void holdCursorsOverCommit() {
        this.setHoldability(1);
    }

    public void closeCursorsAtCommit() {
        this.setHoldability(2);
    }

    public boolean isInDebugMode() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.checkCreated();
        this.debug = debug;
    }

    public void setDebugMode() {
        this.setDebug(true);
    }

    public String[] getGeneratedColumnNames() {
        return this.generatedColumns;
    }

    public void setGeneratedColumns(String ... columns) {
        this.checkCreated();
        this.generatedColumns = columns;
    }

    public void setGeneratedKey() {
        this.setGeneratedColumns(new String[0]);
    }

    public void resetGeneratedColumns() {
        this.checkCreated();
        this.generatedColumns = null;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int rows) {
        this.checkNotClosed();
        this.fetchSize = rows;
        if (this.statement != null) {
            try {
                this.statement.setFetchSize(this.fetchSize);
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Unable to set fetch size: " + this.fetchSize, sex);
            }
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.checkNotClosed();
        this.maxRows = maxRows;
        if (this.statement != null) {
            try {
                this.statement.setMaxRows(maxRows);
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Unable to set max rows: " + maxRows, sex);
            }
        }
    }

    public long getExecutionTime() {
        return this.elapsed;
    }

    public ResultSet execute() {
        this.start = System.currentTimeMillis();
        this.init();
        ResultSet rs = null;
        if (log.isDebugEnabled()) {
            log.debug("Executing statement: " + this.getQueryString());
        }
        try {
            rs = this.preparedStatement == null ? this.statement.executeQuery(this.query.sql) : this.preparedStatement.executeQuery();
            rs.setFetchSize(this.fetchSize);
        }
        catch (SQLException sex) {
            DbUtil.close(rs);
            throw new DbSqlException(this, "Query execution failed", sex);
        }
        this.saveResultSet(rs);
        ++totalOpenResultSetCount;
        this.elapsed = System.currentTimeMillis() - this.start;
        if (log.isDebugEnabled()) {
            log.debug("execution time: " + this.elapsed + "ms");
        }
        return rs;
    }

    public int executeUpdate() {
        return this.executeUpdate(this.autoClose);
    }

    protected int executeUpdate(boolean closeQuery) {
        int result;
        this.start = System.currentTimeMillis();
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("Executing update: " + this.getQueryString());
        }
        try {
            result = this.preparedStatement == null ? (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? this.statement.executeUpdate(this.query.sql, 1) : this.statement.executeUpdate(this.query.sql, this.generatedColumns)) : this.statement.executeUpdate(this.query.sql)) : this.preparedStatement.executeUpdate();
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Query execution failed", sex);
        }
        if (closeQuery) {
            this.close();
        }
        this.elapsed = System.currentTimeMillis() - this.start;
        if (log.isDebugEnabled()) {
            log.debug("execution time: " + this.elapsed + "ms");
        }
        return result;
    }

    public long executeCount() {
        return this.executeCount(this.autoClose);
    }

    protected long executeCount(boolean close) {
        long l;
        this.start = System.currentTimeMillis();
        this.init();
        ResultSet rs = null;
        if (log.isDebugEnabled()) {
            log.debug("Executing prepared count: " + this.getQueryString());
        }
        try {
            rs = this.preparedStatement == null ? this.statement.executeQuery(this.query.sql) : this.preparedStatement.executeQuery();
            long firstLong = DbUtil.getFirstLong(rs);
            this.elapsed = System.currentTimeMillis() - this.start;
            if (log.isDebugEnabled()) {
                log.debug("execution time: " + this.elapsed + "ms");
            }
            l = firstLong;
        }
        catch (SQLException sex) {
            try {
                throw new DbSqlException(this, "Count query failed", sex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                if (close) {
                    this.close();
                }
                throw throwable;
            }
        }
        DbUtil.close(rs);
        if (close) {
            this.close();
        }
        return l;
    }

    public <T> List<T> list(QueryMapper<T> queryMapper) {
        ResultSet resultSet = this.execute();
        ArrayList<T> list = new ArrayList<T>();
        try {
            while (resultSet.next()) {
                T t = queryMapper.process(resultSet);
                if (t == null) {
                    break;
                }
                list.add(t);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
        finally {
            DbUtil.close(resultSet);
        }
        return list;
    }

    public <T> T find(QueryMapper<T> queryMapper) {
        ResultSet resultSet = this.execute();
        try {
            if (resultSet.next()) {
                T t = queryMapper.process(resultSet);
                return t;
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
        finally {
            DbUtil.close(resultSet);
        }
        return null;
    }

    public <T> Set<T> listSet(QueryMapper<T> queryMapper) {
        ResultSet resultSet = this.execute();
        HashSet<T> set = new HashSet<T>();
        try {
            while (resultSet.next()) {
                T t = queryMapper.process(resultSet);
                if (t == null) {
                    break;
                }
                set.add(t);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
        finally {
            DbUtil.close(resultSet);
        }
        return set;
    }

    public ResultSet getGeneratedColumns() {
        ResultSet rs;
        this.checkInitialized();
        if (this.generatedColumns == null) {
            throw new DbSqlException(this, "No column is specified as auto-generated");
        }
        try {
            rs = this.statement.getGeneratedKeys();
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "No generated keys", sex);
        }
        this.saveResultSet(rs);
        ++totalOpenResultSetCount;
        return rs;
    }

    public long getGeneratedKey() {
        this.checkInitialized();
        ResultSet rs = this.getGeneratedColumns();
        try {
            long l = DbUtil.getFirstLong(rs);
            return l;
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "No generated key as long", sex);
        }
        finally {
            DbUtil.close(rs);
            this.resultSets.remove(rs);
            --totalOpenResultSetCount;
        }
    }

    public String getQueryString() {
        if (this.preparedStatement != null && this.debug) {
            return LoggablePreparedStatementFactory.getQueryString(this.preparedStatement);
        }
        if (this.query != null) {
            return this.query.sql;
        }
        return this.sqlString;
    }

    public String toString() {
        return this.getQueryString();
    }

    public static int getTotalOpenResultSetCount() {
        return totalOpenResultSetCount;
    }

    public int getOpenResultSetCount() {
        return this.resultSets == null ? 0 : this.resultSets.size();
    }
}

