<%@ page language="java" contentType="text/html; charset=utf-8"
    pageEncoding="utf-8"%>
<%@ page language="java" import="java.util.*" %>
<%@ page language="java" import="com.tinyhomeutil.homedisk.action.*" %>
<%@ page language="java" import="com.tinyhomeutil.homedisk.i18n.*" %>
<%@ page language="java" import="com.tinyhomeutil.homedisk.util.*" %>
<%@ page language="java" import="com.tinyhomeutil.homedisk.pojo.*" %>
<%@ page language="java" import="com.tinyhomeutil.homedisk.dao.*" %>
<%@ page language="java" import="com.tinyhomeutil.homedisk.filter.*" %>
<%
Locale locale = request.getLocale();
ResourceBundle messages = LocaleToolkit.getBundle(locale);
String title = ProductInfo.getProductName() + " - " +
			   messages.getString("install_page_title");

IGlobal gAction = (IGlobal)ActionFacotry.getInstance().getAction(SwitchAction.GLOBAL_NOTICE);
String noticeDivId = "#modal-notice";
String noticeWindowId = "#notice";

String nextlink = "install.jsp";
boolean isH2Database = InstallDatabase.isH2Database();
int maxStepCount = 7;
if ( isH2Database ) maxStepCount = 6;
String exceptionStr = null;

%>
  <head>
    <meta name="renderer" content="webkit">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" href="../../favicon.ico">

    <title><%=title %></title>

    <!-- Bootstrap core CSS -->
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="css/01.css" rel="stylesheet">
	<link href="css/signin.css" rel="stylesheet">
	
    <!-- Custom styles for this template -->
    <link href="css/starter-template.css" rel="stylesheet">

    <!-- Just for debugging purposes. Don't actually copy these 2 lines! -->
    <!--[if lt IE 9]><script src="../../assets/js/ie8-responsive-file-warning.js"></script><![endif]-->
    <script src="js/ie-emulation-modes-warning.js"></script>

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
      <script src="js/html5shiv.min.js"></script>
      <script src="js/respond.min.js"></script>
    <![endif]-->
  </head>

  <body>

    <div class="container">
    
      <%
      if ( !Constant.INSTALL_MODEL.equals(request.getParameter("m")) ) {
      %>
      <form class="form-signin" method="post" action="<%=nextlink %>">
        <h2 class="form-signin-heading">
          <%=messages.getString("install_title") %>
        </h2>
        
        <input type="hidden" name="m" value="<%=Constant.INSTALL_MODEL%>">
        
        <%if ( !isH2Database ) {%>
        <label for="inputUserName" class="sr-only">
          <%=messages.getString("mysql_database_name") %>
        </label>
        <input type="text" name="<%=Constant.INSTALL_DATABASE_NAME %>" class="form-control" placeholder="<%=messages.getString("mysql_database_name") %>" required autofocus value="homedisk">
        <%} %>
        
        <label for="inputPassword" class="sr-only">
          <%=messages.getString("mysql_url") %>
        </label>
        <%if ( isH2Database ) {%>
        <input type="hidden" name="<%=Constant.INSTALL_URL %>" class="form-control" placeholder="<%=messages.getString("mysql_url") %>" required value="jdbc:h2:~/homedisk">
        <%} else {%>
        <input type="text" name="<%=Constant.INSTALL_URL %>" class="form-control" placeholder="<%=messages.getString("mysql_url") %>" required value="jdbc:mysql://127.0.0.1:3306/">
        <%}%>
        
        <label for="inputUserName" class="sr-only">
          <%=messages.getString("mysql_driver_name") %>
        </label>
        <%if ( isH2Database ) {%>
        <input type="hidden" name="<%=Constant.INSTALL_DRIVER_NAME %>" class="form-control" placeholder="<%=messages.getString("mysql_driver_name") %>" required value="org.h2.Driver">
        <%} else {%>
        <input type="text" name="<%=Constant.INSTALL_DRIVER_NAME %>" class="form-control" placeholder="<%=messages.getString("mysql_driver_name") %>" required value="com.mysql.jdbc.Driver">
        <%}%>
        
        <label for="inputUserName" class="sr-only">
          <%=messages.getString("mysql_user_name") %>
        </label>
        <%if ( isH2Database ) {%>
        <input type="text" name="<%=Constant.INSTALL_USER_NAME %>" class="form-control" placeholder="<%=messages.getString("mysql_user_name") %>" required value="sa">
        <%} else {%>
        <input type="text" name="<%=Constant.INSTALL_USER_NAME %>" class="form-control" placeholder="<%=messages.getString("mysql_user_name") %>" required value="root">
        <%}%>
        
        <label for="inputUserName" class="sr-only">
          <%=messages.getString("mysql_password") %>
        </label>
        <input type="password" name="<%=Constant.INSTALL_PASSWORD %>" class="form-control" placeholder="<%=messages.getString("mysql_password") %>" >

        <button class="btn btn-lg btn-primary btn-block" type="submit">
          <%=messages.getString("install_start") %>
        </button>
      </form>
      <% 
      } else {
      %>	  
      <div class="progress-style-2">
        <h4><%=messages.getString("install_prograss_title") %><span id="progress-result">&nbsp;</span></h4>
        <div class="progress">
		  <div id="progress" class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%">
		    0% <span class="sr-only">0% Complete (success)</span>
		  </div>
        </div>
      </div>
      <%} %>
    </div> <!-- /container -->
	
	<!-- Modal -->
	<div class="modal fade" id="notice" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	  <div class="modal-dialog modal-sm">
		<div class="modal-content">
		  <div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title" id="myModalLabel"><%=messages.getString("notice") %></h4>
		  </div>
		  <div class="modal-body text-style-2" id="modal-notice" >
		  
		  </div>
		  <script type="text/javascript">
		    var exceptionShowed = false;
		    var showException = function(){
		    	if ( exceptionShowed ) {
		    		return;
		    	}
		    	exceptionShowed = true;
		    	if ( "<%=Constant.PARAM_RETURN_FAIL %>" === "<%=request.getParameter(Constant.PARAM_RETURN)  %>" ) {
		    		$("#modal-notice").html($("#modal-notice").html() + "<br/><em>" + "<%=messages.getString("install_exception_info_title") %>" + "<br/>" + "<%=session.getAttribute(Constant.INSTALL_EXCPTION) %>" + "</em>"); 
		    	}
		    }
		  </script>
		  <div class="modal-footer">
		    <button type="button" id="exceptionBtn" class="btn btn-default btn-warning" onclick="showException()"><%=messages.getString("install_exception_info_btn") %></button>
			<button type="button" class="btn btn-default" data-dismiss="modal"><%=messages.getString("close") %></button>
		  </div>
		</div>
	  </div>
	</div>
	<!-- Bootstrap core JavaScript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="bootstrap/js/jquery.min.js"></script>
    <script src="bootstrap/js/bootstrap.min.js"></script>
    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <script src="bootstrap/js/ie10-viewport-bug-workaround.js"></script>
    <%=gAction.getNoticeHTML(messages, request, noticeDivId, noticeWindowId)%>
    
    
  </body>
</html>

	<%  
	if ( Constant.INSTALL_MODEL.equals(request.getParameter("m")) ) {
	%>
      	<script>
      	var progressArray = new Array();
        var push = function(percentage,actionName) {
            var progressItem = new Object();
            progressItem.percentage = percentage;
            progressItem.actionName = actionName;
            progressArray.push(progressItem);
        }
        var index = 0;
        
        var updateProgress = function(){
        	var percentageStr;
        	var progressItem;
        	if ( index < progressArray.length ) {
    			progressItem = progressArray[index];
    			percentageStr = ( parseFloat(progressItem.percentage) * 100 ) +"%";
        		$("#progress").css("width",percentageStr);
        		$("#progress").html(percentageStr + " <span class='sr-only'>"+ percentageStr +" Complete (success)</span>");
        		$("#progress-result").html(progressItem.actionName + "&nbsp;");
        		//alert(index + "," + percentageStr + "," + progressItem.actionName);
    			index++;	
    		} else {
    			if ( index > <%=maxStepCount%> ) {
    				return;
    			} else if ( index == <%=maxStepCount%> ) {
    				<%if ( !isH2Database ) {%>
    				setTimeout(updateProgress,2000);
    				window.location.href='index.jsp';
    				<%}%>
    				i++;
    			}
    		}
        	setTimeout(updateProgress,500); 
        } 
        
        updateProgress();
      	</script>
      	
      	
    <%  
      InstallDatabase.isDatabaseNameEmpty();
      
      String databaseName = "";
      boolean isNull = false;
      if ( !isH2Database ) {
        databaseName = request.getParameter(Constant.INSTALL_DATABASE_NAME);
        isNull = Toolkit.isNull(databaseName, nextlink, "install_database_name_null_notice",response);
        if ( isNull ) return;
      }
            
      String userName = request.getParameter(Constant.INSTALL_USER_NAME);
      isNull = Toolkit.isNull(userName, nextlink, "install_user_name_null_notice",response);
      if ( isNull ) return;
      
      String driverName = request.getParameter(Constant.INSTALL_DRIVER_NAME);
      isNull = Toolkit.isNull(driverName, nextlink, "install_dirver_name_null_notice",response);
      if ( isNull ) return;
      
      String url = request.getParameter(Constant.INSTALL_URL);
	  if ( isH2Database ) {
        url = InstallDatabase.getH2JDBCURLToJSP(request);
      }

      isNull = Toolkit.isNull(url, nextlink, "install_url_null_notice",response);
      if ( isNull ) return;
      
      String password = request.getParameter(Constant.INSTALL_PASSWORD);
      
      JDBCInfo info = JDBCInfo.getInstance();
      info.setUserName(userName);
      info.setPassword(password);
      info.setDriverClass(driverName);
      info.setJdbcUrl(Toolkit.cutStringEnd(url,"?"));
      
      
      if ( !isH2Database ) {
    	        
      if ( (exceptionStr=InstallDatabase.createDatabase(databaseName)) == null ) {
	%>
      	<script>push("0.15","<%=messages.getString("install_progress_create_database") %>");</script>
    <%
   
    	  if ( (exceptionStr=InstallDatabase.installUserTable()) == null  ) {	  
    %>
    	<script>push("0.3","<%=messages.getString("install_progress_install_user_table") %>");</script>
    <%  
    	  } else {
    		  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_user_table_fail_notice"));
        	  return;
    	  }
    	  
		  if ( (exceptionStr=InstallDatabase.installAlbumTable()) == null  ) {
	%>
		<script>push("0.45","<%=messages.getString("install_progress_install_album_table") %>");</script>
	<%		    
		  }else {
			  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_album_table_fail_notice"));
        	  return;
    	  }
		 
		  if ( (exceptionStr=InstallDatabase.installResourceTable()) == null  ) {
	%>
		<script>push("0.6","<%=messages.getString("install_progress_install_resource_table") %>");</script>
	<%		  
		  }else {
			  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_resource_table_fail_notice"));
        	  return;
    	  }
		 
		  //插入数据
		  if ( (exceptionStr=InstallDatabase.initData()) == null  ) {
	%>
		<script>push("0.75","<%=messages.getString("install_progress_insert_data") %>");</script>
	<%		  
		  }else {
			  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_init_data_fail_notice"));
        	  return;
    	  }
		  				  
		  //save
		  if ( (exceptionStr=InstallDatabase.saveConfig()) == null  ) {
	%>
		<script>push("0.9","<%=messages.getString("install_progress_save_config") %>");</script>
	<%		  
		  }else {
			  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_save_config_fail_notice"));
        	  return;
    	  }
    	  
      } else {
    	  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
    	  response.sendRedirect(Toolkit.failLink(nextlink, "install_database_fail_notice"));
    	  return;
      }
      
      //通知过滤器表已经建完，可以正常使用
      InstallFilter.isTabledInstalled = InstallDatabase.isTablesInstalled();
    %>  
      <script>push("1","<%=messages.getString("install_finish_notice") %>");</script>
    <%
	} else {
				  if ( (exceptionStr=InstallDatabase.installUserTableInH2()) == null  ) {	  
		    %>
		    	<script>push("0.3","<%=messages.getString("install_progress_install_user_table") %>");</script>
		    <%  
		    	  } else {
		    		  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
		    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_user_table_fail_notice"));
		        	  return;
		    	  }
		    	  
				  if ( (exceptionStr=InstallDatabase.installAlbumTableInH2()) == null  ) {
			%>
				<script>push("0.45","<%=messages.getString("install_progress_install_album_table") %>");</script>
			<%		    
				  }else {
					  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
		    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_album_table_fail_notice"));
		        	  return;
		    	  }
				 
				  if ( (exceptionStr=InstallDatabase.installResourceTableInH2()) == null  ) {
			%>
				<script>push("0.6","<%=messages.getString("install_progress_install_resource_table") %>");</script>
			<%		  
				  }else {
					  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
		    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_resource_table_fail_notice"));
		        	  return;
		    	  }
				 
				  //插入数据
				  if ( (exceptionStr=InstallDatabase.initDataInH2()) == null  ) {
			%>
				<script>push("0.75","<%=messages.getString("install_progress_insert_data") %>");</script>
			<%		  
				  }else {
					  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
		    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_init_data_fail_notice"));
		        	  return;
		    	  }
				  				  
				  //save
				  if ( (exceptionStr=InstallDatabase.saveConfig()) == null  ) {
			%>
				<script>push("0.9","<%=messages.getString("install_progress_save_config") %>");</script>
			<%		  
				  }else {
					  session.setAttribute(Constant.INSTALL_EXCPTION, exceptionStr);
		    		  response.sendRedirect(Toolkit.failLink(nextlink, "install_save_config_fail_notice"));
		        	  return;
		    	  }
				//通知过滤器表已经建完，可以正常使用
				    InstallFilter.isTabledInstalled = InstallDatabase.isTablesInstalled();
				  %>  
				    <script>push("1","<%=messages.getString("install_h2_finish_notice") %>");</script>
				  <%	 
	}
      
	} 
	
    %>