/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Application;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacPasteboard {
    public static final int General = 1;
    public static final int DragAndDrop = 2;
    public static final int UtfIndex = 0;
    public static final int ObjectIndex = 1;
    public static final String UtfString = "public.utf8-plain-text";
    public static final String UtfPdf = "com.adobe.pdf";
    public static final String UtfTiff = "public.tiff";
    public static final String UtfPng = "public.png";
    public static final String UtfRtf = "public.rtf";
    public static final String UtfRtfd = "com.apple.flat-rtfd";
    public static final String UtfHtml = "public.html";
    public static final String UtfTabularText = "public.utf8-tab-separated-values-text";
    public static final String UtfFont = "com.apple.cocoa.pasteboard.character-formatting";
    public static final String UtfColor = "com.apple.cocoa.pasteboard.color";
    public static final String UtfSound = "com.apple.cocoa.pasteboard.sound";
    public static final String UtfMultipleTextSelection = "com.apple.cocoa.pasteboard.multiple-text-selection";
    public static final String UtfFindPanelSearchOptions = "com.apple.cocoa.pasteboard.find-panel-search-options";
    public static final String UtfUrl = "public.url";
    public static final String UtfFileUrl = "public.file-url";
    private long ptr = 0L;
    private boolean user;

    static native void _initIDs();

    private native long _createSystemPasteboard(int var1);

    public MacPasteboard(int n) {
        this.user = false;
        this.ptr = this._createSystemPasteboard(n);
    }

    private native long _createUserPasteboard(String var1);

    public MacPasteboard(String string) {
        this.user = true;
        this.ptr = this._createUserPasteboard(string);
    }

    public long getNativePasteboard() {
        this.assertValid();
        return this.ptr;
    }

    private native String _getName(long var1);

    public String getName() {
        this.assertValid();
        return this._getName(this.ptr);
    }

    private native String[][] _getUTFs(long var1);

    public String[][] getUTFs() {
        this.assertValid();
        return this._getUTFs(this.ptr);
    }

    private native byte[] _getItemAsRawImage(long var1, int var3);

    public byte[] getItemAsRawImage(int n) {
        this.assertValid();
        return this._getItemAsRawImage(this.ptr, n);
    }

    private native String _getItemAsString(long var1, int var3);

    public String getItemAsString(int n) {
        this.assertValid();
        return this._getItemAsString(this.ptr, n);
    }

    private native String _getItemStringForUTF(long var1, int var3, String var4);

    public String getItemStringForUTF(int n, String string) {
        this.assertValid();
        return this._getItemStringForUTF(this.ptr, n, string);
    }

    private native byte[] _getItemBytesForUTF(long var1, int var3, String var4);

    public byte[] getItemBytesForUTF(int n, String string) {
        this.assertValid();
        return this._getItemBytesForUTF(this.ptr, n, string);
    }

    private native long _getItemForUTF(long var1, int var3, String var4);

    public long getItemForUTF(int n, String string) {
        this.assertValid();
        return this._getItemForUTF(this.ptr, n, string);
    }

    private native long _putItemsFromArray(long var1, Object[] var3, int var4);

    public long putItemsFromArray(Object[] objectArray, int n) {
        return this._putItemsFromArray(this.ptr, objectArray, n);
    }

    private Object[] hashMapToArray(HashMap hashMap) {
        Object[] objectArray = null;
        if (hashMap != null && hashMap.size() > 0) {
            objectArray = new Object[hashMap.size()];
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object[] objectArray2 = new Object[2];
                String string = (String)iterator.next();
                objectArray2[0] = string;
                objectArray2[1] = hashMap.get(string);
                objectArray[n++] = objectArray2;
            }
        }
        return objectArray;
    }

    public long putItems(HashMap<String, Object>[] hashMapArray, int n) {
        this.assertValid();
        Object[] objectArray = null;
        if (hashMapArray.length > 0) {
            objectArray = new Object[hashMapArray.length];
            for (int i = 0; i < hashMapArray.length; ++i) {
                objectArray[i] = this.hashMapToArray(hashMapArray[i]);
            }
        }
        return this.putItemsFromArray(objectArray, n);
    }

    private native long _clear(long var1);

    public long clear() {
        this.assertValid();
        return this._clear(this.ptr);
    }

    private native long _getSeed(long var1);

    public long getSeed() {
        this.assertValid();
        return this._getSeed(this.ptr);
    }

    private native int _getAllowedOperation(long var1);

    public int getAllowedOperation() {
        this.assertValid();
        return this._getAllowedOperation(this.ptr);
    }

    private native void _release(long var1);

    public void release() {
        this.assertValid();
        if (this.ptr != 0L && this.user) {
            this._release(this.ptr);
        }
        this.ptr = 0L;
    }

    private void assertValid() {
        if (this.ptr == 0L) {
            throw new IllegalStateException("The MacPasteboard is not valid");
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Application.loadNativeLibrary();
                return null;
            }
        });
        MacPasteboard._initIDs();
    }
}

