/*
 * Decompiled with CFR 0.152.
 */
package javax.smartcardio;

import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.List;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactorySpi;
import sun.security.action.GetPropertyAction;
import sun.security.jca.GetInstance;

public final class TerminalFactory {
    private static final String PROP_NAME = "javax.smartcardio.TerminalFactory.DefaultType";
    private static final String defaultType;
    private static final TerminalFactory defaultFactory;
    private final TerminalFactorySpi spi;
    private final Provider provider;
    private final String type;

    private TerminalFactory(TerminalFactorySpi terminalFactorySpi, Provider provider, String string) {
        this.spi = terminalFactorySpi;
        this.provider = provider;
        this.type = string;
    }

    public static String getDefaultType() {
        return defaultType;
    }

    public static TerminalFactory getDefault() {
        return defaultFactory;
    }

    public static TerminalFactory getInstance(String string, Object object) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("TerminalFactory", TerminalFactorySpi.class, string, object);
        return new TerminalFactory((TerminalFactorySpi)instance.impl, instance.provider, string);
    }

    public static TerminalFactory getInstance(String string, Object object, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("TerminalFactory", TerminalFactorySpi.class, string, object, string2);
        return new TerminalFactory((TerminalFactorySpi)instance.impl, instance.provider, string);
    }

    public static TerminalFactory getInstance(String string, Object object, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("TerminalFactory", TerminalFactorySpi.class, string, object, provider);
        return new TerminalFactory((TerminalFactorySpi)instance.impl, instance.provider, string);
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getType() {
        return this.type;
    }

    public CardTerminals terminals() {
        return this.spi.engineTerminals();
    }

    public String toString() {
        return "TerminalFactory for type " + this.type + " from provider " + this.provider.getName();
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction(PROP_NAME, "PC/SC")).trim();
        TerminalFactory terminalFactory = null;
        try {
            terminalFactory = TerminalFactory.getInstance(string, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (terminalFactory == null) {
            try {
                string = "PC/SC";
                Provider provider = Security.getProvider("SunPCSC");
                if (provider == null) {
                    Class<?> clazz = Class.forName("sun.security.smartcardio.SunPCSC");
                    provider = (Provider)clazz.newInstance();
                }
                terminalFactory = TerminalFactory.getInstance(string, null, provider);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (terminalFactory == null) {
            string = "None";
            terminalFactory = new TerminalFactory(NoneFactorySpi.INSTANCE, NoneProvider.INSTANCE, "None");
        }
        defaultType = string;
        defaultFactory = terminalFactory;
    }

    private static final class NoneCardTerminals
    extends CardTerminals {
        static final CardTerminals INSTANCE = new NoneCardTerminals();

        private NoneCardTerminals() {
        }

        @Override
        public List<CardTerminal> list(CardTerminals.State state) throws CardException {
            if (state == null) {
                throw new NullPointerException();
            }
            return Collections.emptyList();
        }

        @Override
        public boolean waitForChange(long l) throws CardException {
            throw new IllegalStateException("no terminals");
        }
    }

    private static final class NoneFactorySpi
    extends TerminalFactorySpi {
        static final TerminalFactorySpi INSTANCE = new NoneFactorySpi();

        private NoneFactorySpi() {
        }

        @Override
        protected CardTerminals engineTerminals() {
            return NoneCardTerminals.INSTANCE;
        }
    }

    private static final class NoneProvider
    extends Provider {
        static final Provider INSTANCE = new NoneProvider();

        private NoneProvider() {
            super("None", 1.0, "none");
        }
    }
}

