/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.client;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.ha.StickyFeature;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.client.ClientTransportException;
import com.sun.xml.internal.ws.developer.HttpConfigFeature;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.transport.Headers;
import com.sun.xml.internal.ws.transport.http.client.HttpClientTransport;
import com.sun.xml.internal.ws.transport.http.client.HttpResponseProperties;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.RuntimeVersion;
import com.sun.xml.internal.ws.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.SOAPBinding;

public class HttpTransportPipe
extends AbstractTubeImpl {
    private final Codec codec;
    private final WSBinding binding;
    private static final List<String> USER_AGENT;
    private final CookieHandler cookieJar;
    private final boolean sticky;
    public static boolean dump;

    public HttpTransportPipe(Codec codec, WSBinding wSBinding) {
        this.codec = codec;
        this.binding = wSBinding;
        this.sticky = HttpTransportPipe.isSticky(wSBinding);
        HttpConfigFeature httpConfigFeature = wSBinding.getFeature(HttpConfigFeature.class);
        if (httpConfigFeature == null) {
            httpConfigFeature = new HttpConfigFeature();
        }
        this.cookieJar = httpConfigFeature.getCookieHandler();
    }

    private static boolean isSticky(WSBinding wSBinding) {
        WebServiceFeature[] webServiceFeatureArray;
        boolean bl = false;
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray = wSBinding.getFeatures().toArray()) {
            if (!(webServiceFeature instanceof StickyFeature)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private HttpTransportPipe(HttpTransportPipe httpTransportPipe, TubeCloner tubeCloner) {
        this(httpTransportPipe.codec.copy(), httpTransportPipe.binding);
        tubeCloner.add(httpTransportPipe, this);
    }

    @Override
    public NextAction processException(@NotNull Throwable throwable) {
        throw new IllegalStateException("HttpTransportPipe's processException shouldn't be called.");
    }

    @Override
    public NextAction processRequest(@NotNull Packet packet) {
        return this.doReturnWith(this.process(packet));
    }

    @Override
    public NextAction processResponse(@NotNull Packet packet) {
        throw new IllegalStateException("HttpTransportPipe's processResponse shouldn't be called.");
    }

    @Override
    public Packet process(Packet packet) {
        try {
            Headers headers = new Headers();
            Map map = (Map)packet.invocationProperties.get("javax.xml.ws.http.request.headers");
            boolean bl = true;
            if (map != null) {
                headers.putAll(map);
                if (map.get("User-Agent") != null) {
                    bl = false;
                }
            }
            if (bl) {
                headers.put("User-Agent", USER_AGENT);
            }
            this.addBasicAuth(packet, headers);
            this.addCookies(packet, headers);
            HttpClientTransport httpClientTransport = new HttpClientTransport(packet, headers);
            packet.addSatellite(new HttpResponseProperties(httpClientTransport));
            ContentType contentType = this.codec.getStaticContentType(packet);
            if (contentType == null) {
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                contentType = this.codec.encode(packet, byteArrayBuffer);
                headers.put("Content-Length", Collections.singletonList(Integer.toString(byteArrayBuffer.size())));
                headers.put("Content-Type", Collections.singletonList(contentType.getContentType()));
                if (contentType.getAcceptHeader() != null) {
                    headers.put("Accept", Collections.singletonList(contentType.getAcceptHeader()));
                }
                if (this.binding instanceof SOAPBinding) {
                    this.writeSOAPAction(headers, contentType.getSOAPActionHeader());
                }
                if (dump) {
                    this.dump(byteArrayBuffer, "HTTP request", headers);
                }
                byteArrayBuffer.writeTo(httpClientTransport.getOutput());
            } else {
                headers.put("Content-Type", Collections.singletonList(contentType.getContentType()));
                if (contentType.getAcceptHeader() != null) {
                    headers.put("Accept", Collections.singletonList(contentType.getAcceptHeader()));
                }
                if (this.binding instanceof SOAPBinding) {
                    this.writeSOAPAction(headers, contentType.getSOAPActionHeader());
                }
                if (dump) {
                    ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                    this.codec.encode(packet, byteArrayBuffer);
                    this.dump(byteArrayBuffer, "HTTP request - " + packet.endpointAddress, headers);
                    OutputStream outputStream = httpClientTransport.getOutput();
                    if (outputStream != null) {
                        byteArrayBuffer.writeTo(outputStream);
                    }
                } else {
                    OutputStream outputStream = httpClientTransport.getOutput();
                    if (outputStream != null) {
                        this.codec.encode(packet, outputStream);
                    }
                }
            }
            httpClientTransport.closeOutput();
            return this.createResponsePacket(packet, httpClientTransport);
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    private Packet createResponsePacket(Packet packet, HttpClientTransport httpClientTransport) throws IOException {
        httpClientTransport.readResponseCodeAndMessage();
        this.recordCookies(packet, httpClientTransport);
        InputStream inputStream = httpClientTransport.getInput();
        if (dump) {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            if (inputStream != null) {
                byteArrayBuffer.write(inputStream);
                inputStream.close();
            }
            this.dump(byteArrayBuffer, "HTTP response - " + packet.endpointAddress + " - " + httpClientTransport.statusCode, httpClientTransport.getHeaders());
            inputStream = byteArrayBuffer.newInputStream();
        }
        int n = httpClientTransport.contentLength;
        InputStream inputStream2 = null;
        if (n == -1 && (inputStream2 = StreamUtils.hasSomeData(inputStream)) != null) {
            inputStream = inputStream2;
        }
        if ((n == 0 || n == -1 && inputStream2 == null) && inputStream != null) {
            inputStream.close();
            inputStream = null;
        }
        this.checkStatusCode(inputStream, httpClientTransport);
        Packet packet2 = packet.createClientResponse(null);
        packet2.wasTransportSecure = httpClientTransport.isSecure();
        if (inputStream != null) {
            String string = httpClientTransport.getContentType();
            if (string != null && string.contains("text/html") && this.binding instanceof SOAPBinding) {
                throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(httpClientTransport.statusCode, httpClientTransport.statusMessage));
            }
            this.codec.decode(inputStream, string, packet2);
        }
        return packet2;
    }

    private void checkStatusCode(InputStream inputStream, HttpClientTransport httpClientTransport) throws IOException {
        int n = httpClientTransport.statusCode;
        String string = httpClientTransport.statusMessage;
        if (this.binding instanceof SOAPBinding) {
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                if (n == 200 || n == 202 || this.isErrorCode(n)) {
                    if (this.isErrorCode(n) && inputStream == null) {
                        throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(n, string));
                    }
                    return;
                }
            } else if (n == 200 || n == 202 || n == 500) {
                if (n == 500 && inputStream == null) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(n, string));
                }
                return;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(n, string));
        }
    }

    private boolean isErrorCode(int n) {
        return n == 500 || n == 400;
    }

    private void addCookies(Packet packet, Map<String, List<String>> map) throws IOException {
        Boolean bl = (Boolean)packet.invocationProperties.get("javax.xml.ws.session.maintain");
        if (bl != null && !bl.booleanValue()) {
            return;
        }
        if (this.sticky || bl != null && bl.booleanValue()) {
            Map<String, List<String>> map2 = this.cookieJar.get(packet.endpointAddress.getURI(), map);
            List<String> list = map2.get("Cookie");
            if (list != null && !list.isEmpty()) {
                map.put("Cookie", list);
            }
            if ((list = map2.get("Cookie2")) != null && !list.isEmpty()) {
                map.put("Cookie2", list);
            }
        }
    }

    private void recordCookies(Packet packet, HttpClientTransport httpClientTransport) throws IOException {
        Boolean bl = (Boolean)packet.invocationProperties.get("javax.xml.ws.session.maintain");
        if (bl != null && !bl.booleanValue()) {
            return;
        }
        if (this.sticky || bl != null && bl.booleanValue()) {
            this.cookieJar.put(packet.endpointAddress.getURI(), httpClientTransport.getHeaders());
        }
    }

    private void addBasicAuth(Packet packet, Map<String, List<String>> map) {
        String string;
        String string2 = (String)packet.invocationProperties.get("javax.xml.ws.security.auth.username");
        if (string2 != null && (string = (String)packet.invocationProperties.get("javax.xml.ws.security.auth.password")) != null) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(":");
            stringBuffer.append(string);
            String string3 = DatatypeConverter.printBase64Binary(stringBuffer.toString().getBytes());
            map.put("Authorization", Collections.singletonList("Basic " + string3));
        }
    }

    private void writeSOAPAction(Map<String, List<String>> map, String string) {
        if (SOAPVersion.SOAP_12.equals((Object)this.binding.getSOAPVersion())) {
            return;
        }
        if (string != null) {
            map.put("SOAPAction", Collections.singletonList(string));
        } else {
            map.put("SOAPAction", Collections.singletonList("\"\""));
        }
    }

    @Override
    public void preDestroy() {
    }

    @Override
    public HttpTransportPipe copy(TubeCloner tubeCloner) {
        return new HttpTransportPipe(this, tubeCloner);
    }

    private void dump(ByteArrayBuffer byteArrayBuffer, String string, Map<String, List<String>> map) throws IOException {
        System.out.println("---[" + string + "]---");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
        byteArrayBuffer.writeTo(System.out);
        System.out.println("--------------------");
    }

    static {
        boolean bl;
        USER_AGENT = Collections.singletonList(RuntimeVersion.VERSION.toString());
        try {
            JAXBContext.newInstance(new Class[0]).createUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        try {
            bl = Boolean.getBoolean(HttpTransportPipe.class.getName() + ".dump");
        }
        catch (Throwable throwable) {
            bl = false;
        }
        dump = bl;
    }
}

