/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.jaxws;

import com.sun.xml.internal.ws.addressing.policy.AddressingFeatureConfigurator;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLService;
import com.sun.xml.internal.ws.encoding.policy.FastInfosetFeatureConfigurator;
import com.sun.xml.internal.ws.encoding.policy.MtomFeatureConfigurator;
import com.sun.xml.internal.ws.encoding.policy.SelectOptimalEncodingFeatureConfigurator;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapKey;
import com.sun.xml.internal.ws.policy.jaxws.spi.PolicyFeatureConfigurator;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

public class PolicyUtil {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyUtil.class);
    private static final Collection<PolicyFeatureConfigurator> CONFIGURATORS = new LinkedList<PolicyFeatureConfigurator>();

    public static <T> void addServiceProviders(Collection<T> collection, Class<T> clazz) {
        Iterator<T> iterator = ServiceFinder.find(clazz).iterator();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static void configureModel(WSDLModel wSDLModel, PolicyMap policyMap) throws PolicyException {
        LOGGER.entering(wSDLModel, policyMap);
        for (WSDLService wSDLService : wSDLModel.getServices().values()) {
            for (WSDLPort wSDLPort : wSDLService.getPorts()) {
                Collection<WebServiceFeature> collection = PolicyUtil.getPortScopedFeatures(policyMap, wSDLService.getName(), wSDLPort.getName());
                for (WebServiceFeature webServiceFeature : collection) {
                    wSDLPort.addFeature(webServiceFeature);
                    wSDLPort.getBinding().addFeature(webServiceFeature);
                }
            }
        }
        LOGGER.exiting();
    }

    public static Collection<WebServiceFeature> getPortScopedFeatures(PolicyMap policyMap, QName qName, QName qName2) {
        LOGGER.entering(policyMap, qName, qName2);
        ArrayList<WebServiceFeature> arrayList = new ArrayList<WebServiceFeature>();
        try {
            PolicyMapKey policyMapKey = PolicyMap.createWsdlEndpointScopeKey(qName, qName2);
            for (PolicyFeatureConfigurator policyFeatureConfigurator : CONFIGURATORS) {
                Collection<WebServiceFeature> collection = policyFeatureConfigurator.getFeatures(policyMapKey, policyMap);
                if (collection == null) continue;
                arrayList.addAll(collection);
            }
        }
        catch (PolicyException policyException) {
            throw new WebServiceException(policyException);
        }
        LOGGER.exiting(arrayList);
        return arrayList;
    }

    static {
        CONFIGURATORS.add(new AddressingFeatureConfigurator());
        CONFIGURATORS.add(new MtomFeatureConfigurator());
        CONFIGURATORS.add(new FastInfosetFeatureConfigurator());
        CONFIGURATORS.add(new SelectOptimalEncodingFeatureConfigurator());
        PolicyUtil.addServiceProviders(CONFIGURATORS, PolicyFeatureConfigurator.class);
    }
}

