/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.client.AsyncInvoker;
import com.sun.xml.internal.ws.client.AsyncResponseImpl;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.ResponseContext;
import com.sun.xml.internal.ws.client.sei.ResponseBuilder;
import com.sun.xml.internal.ws.client.sei.SEIMethodHandler;
import com.sun.xml.internal.ws.client.sei.SEIStub;
import com.sun.xml.internal.ws.client.sei.ValueGetterFactory;
import com.sun.xml.internal.ws.client.sei.ValueSetterFactory;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import java.util.List;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;

abstract class AsyncMethodHandler
extends SEIMethodHandler {
    private final ResponseBuilder responseBuilder;
    @Nullable
    private final Class asyncBeanClass;

    AsyncMethodHandler(SEIStub sEIStub, JavaMethodImpl javaMethodImpl, JavaMethodImpl javaMethodImpl2) {
        super(sEIStub, javaMethodImpl2);
        List<ParameterImpl> list = javaMethodImpl2.getResponseParameters();
        int n = 0;
        for (ParameterImpl object : list) {
            if (object.isWrapperStyle()) {
                ParameterImpl parameterImpl = (WrapperParameter)object;
                n += ((WrapperParameter)parameterImpl).getWrapperChildren().size();
                if (javaMethodImpl2.getBinding().getStyle() != SOAPBinding.Style.DOCUMENT) continue;
                n += 2;
                continue;
            }
            ++n;
        }
        Object object = null;
        if (n > 1) {
            list = javaMethodImpl.getResponseParameters();
            for (ParameterImpl parameterImpl : list) {
                if (parameterImpl.isWrapperStyle()) {
                    WrapperParameter wrapperParameter = (WrapperParameter)parameterImpl;
                    if (javaMethodImpl2.getBinding().getStyle() == SOAPBinding.Style.DOCUMENT) {
                        object = (Class)wrapperParameter.getTypeReference().type;
                        break;
                    }
                    for (ParameterImpl parameterImpl2 : wrapperParameter.getWrapperChildren()) {
                        if (parameterImpl2.getIndex() != -1) continue;
                        object = (Class)parameterImpl2.getTypeReference().type;
                        break;
                    }
                    if (object == null) continue;
                    break;
                }
                if (parameterImpl.getIndex() != -1) continue;
                object = (Class)parameterImpl.getTypeReference().type;
                break;
            }
        }
        this.asyncBeanClass = object;
        switch (n) {
            case 0: {
                this.responseBuilder = this.buildResponseBuilder(javaMethodImpl2, ValueSetterFactory.NONE);
                break;
            }
            case 1: {
                this.responseBuilder = this.buildResponseBuilder(javaMethodImpl2, ValueSetterFactory.SINGLE);
                break;
            }
            default: {
                this.responseBuilder = this.buildResponseBuilder(javaMethodImpl2, new ValueSetterFactory.AsyncBeanValueSetterFactory(this.asyncBeanClass));
            }
        }
    }

    protected final Response<Object> doInvoke(Object object, Object[] objectArray, AsyncHandler asyncHandler) {
        SEIAsyncInvoker sEIAsyncInvoker = new SEIAsyncInvoker(object, objectArray);
        AsyncResponseImpl<Object> asyncResponseImpl = new AsyncResponseImpl<Object>((Runnable)sEIAsyncInvoker, asyncHandler);
        sEIAsyncInvoker.setReceiver(asyncResponseImpl);
        asyncResponseImpl.run();
        return asyncResponseImpl;
    }

    @Override
    ValueGetterFactory getValueGetterFactory() {
        return ValueGetterFactory.ASYNC;
    }

    private class SEIAsyncInvoker
    extends AsyncInvoker {
        private final RequestContext rc;
        private final Object[] args;

        SEIAsyncInvoker(Object object, Object[] objectArray) {
            this.rc = AsyncMethodHandler.this.owner.requestContext.copy();
            this.args = objectArray;
        }

        @Override
        public void do_run() {
            Packet packet = new Packet(AsyncMethodHandler.this.createRequestMessage(this.args));
            packet.soapAction = AsyncMethodHandler.this.soapAction;
            packet.expectReply = !AsyncMethodHandler.this.isOneWay;
            packet.getMessage().assertOneWay(AsyncMethodHandler.this.isOneWay);
            Fiber.CompletionCallback completionCallback = new Fiber.CompletionCallback(){

                @Override
                public void onCompletion(@NotNull Packet packet) {
                    SEIAsyncInvoker.this.responseImpl.setResponseContext(new ResponseContext(packet));
                    Message message = packet.getMessage();
                    if (message == null) {
                        return;
                    }
                    try {
                        if (message.isFault()) {
                            SOAPFaultBuilder sOAPFaultBuilder = SOAPFaultBuilder.create(message);
                            throw sOAPFaultBuilder.createException(AsyncMethodHandler.this.checkedExceptions);
                        }
                        Object[] objectArray = new Object[1];
                        if (AsyncMethodHandler.this.asyncBeanClass != null) {
                            objectArray[0] = AsyncMethodHandler.this.asyncBeanClass.newInstance();
                        }
                        AsyncMethodHandler.this.responseBuilder.readResponse(message, objectArray);
                        SEIAsyncInvoker.this.responseImpl.set(objectArray[0], null);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof RuntimeException) {
                            if (throwable instanceof WebServiceException) {
                                SEIAsyncInvoker.this.responseImpl.set(null, throwable);
                                return;
                            }
                        } else if (throwable instanceof Exception) {
                            SEIAsyncInvoker.this.responseImpl.set(null, throwable);
                            return;
                        }
                        SEIAsyncInvoker.this.responseImpl.set(null, new WebServiceException(throwable));
                    }
                }

                @Override
                public void onCompletion(@NotNull Throwable throwable) {
                    if (throwable instanceof WebServiceException) {
                        SEIAsyncInvoker.this.responseImpl.set(null, throwable);
                    } else {
                        SEIAsyncInvoker.this.responseImpl.set(null, new WebServiceException(throwable));
                    }
                }
            };
            AsyncMethodHandler.this.owner.doProcessAsync(packet, this.rc, completionCallback);
        }
    }
}

