/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.packaging.mime.internet;

import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeMultipart;
import com.sun.xml.internal.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEConfig;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEMessage;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEPart;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.activation.DataSource;

public class MimePullMultipart
extends MimeMultipart {
    private InputStream in = null;
    private String boundary = null;
    private MIMEMessage mm = null;
    private DataSource dataSource = null;
    private ContentType contType = null;
    private String startParam = null;
    private MIMEPart soapPart = null;

    public MimePullMultipart(DataSource dataSource, ContentType contentType) throws MessagingException {
        this.parsed = false;
        this.contType = contentType == null ? new ContentType(dataSource.getContentType()) : contentType;
        this.dataSource = dataSource;
        this.boundary = this.contType.getParameter("boundary");
    }

    public MIMEPart readAndReturnSOAPPart() throws MessagingException {
        if (this.soapPart != null) {
            throw new MessagingException("Inputstream from datasource was already consumed");
        }
        this.readSOAPPart();
        return this.soapPart;
    }

    protected void readSOAPPart() throws MessagingException {
        try {
            if (this.soapPart != null) {
                return;
            }
            this.in = this.dataSource.getInputStream();
            MIMEConfig mIMEConfig = new MIMEConfig();
            this.mm = new MIMEMessage(this.in, this.boundary, mIMEConfig);
            String string = this.contType.getParameter("start");
            if (this.startParam == null) {
                this.soapPart = this.mm.getPart(0);
            } else {
                if (string != null && string.length() > 2 && string.charAt(0) == '<' && string.charAt(string.length() - 1) == '>') {
                    string = string.substring(1, string.length() - 1);
                }
                this.startParam = string;
                this.soapPart = this.mm.getPart(this.startParam);
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("No inputstream from datasource", iOException);
        }
    }

    public void parseAll() throws MessagingException {
        if (this.parsed) {
            return;
        }
        if (this.soapPart == null) {
            this.readSOAPPart();
        }
        List<MIMEPart> list = this.mm.getAttachments();
        for (MIMEPart mIMEPart : list) {
            if (mIMEPart == this.soapPart) continue;
            AttachmentPartImpl attachmentPartImpl = new AttachmentPartImpl(mIMEPart);
            this.addBodyPart(new MimeBodyPart(mIMEPart));
        }
        this.parsed = true;
    }

    @Override
    protected void parse() throws MessagingException {
        this.parseAll();
    }
}

