/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.reflect;

import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.internal.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.internal.bind.v2.runtime.reflect.Lister;

final class PrimitiveArrayListerInteger<BeanT>
extends Lister<BeanT, int[], Integer, IntegerArrayPack> {
    private PrimitiveArrayListerInteger() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Integer.TYPE, new PrimitiveArrayListerInteger());
    }

    @Override
    public ListIterator<Integer> iterator(final int[] nArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Integer>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < nArray.length;
            }

            @Override
            public Integer next() {
                return nArray[this.idx++];
            }
        };
    }

    @Override
    public IntegerArrayPack startPacking(BeanT BeanT, Accessor<BeanT, int[]> accessor) {
        return new IntegerArrayPack();
    }

    @Override
    public void addToPack(IntegerArrayPack integerArrayPack, Integer n) {
        integerArrayPack.add(n);
    }

    @Override
    public void endPacking(IntegerArrayPack integerArrayPack, BeanT BeanT, Accessor<BeanT, int[]> accessor) throws AccessorException {
        accessor.set(BeanT, integerArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, int[]> accessor) throws AccessorException {
        accessor.set(BeanT, new int[0]);
    }

    static final class IntegerArrayPack {
        int[] buf = new int[16];
        int size;

        IntegerArrayPack() {
        }

        void add(Integer n) {
            if (this.buf.length == this.size) {
                int[] nArray = new int[this.buf.length * 2];
                System.arraycopy(this.buf, 0, nArray, 0, this.buf.length);
                this.buf = nArray;
            }
            if (n != null) {
                this.buf[this.size++] = n;
            }
        }

        int[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            int[] nArray = new int[this.size];
            System.arraycopy(this.buf, 0, nArray, 0, this.size);
            return nArray;
        }
    }
}

