/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.utils.ObjectFactory;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.grammars.Grammar;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarLoader;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class XMLGrammarPreparser {
    private static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final Hashtable KNOWN_LOADERS = new Hashtable();
    private static final String[] RECOGNIZED_PROPERTIES;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected XMLGrammarPool fGrammarPool;
    protected Locale fLocale;
    private Hashtable fLoaders;

    public XMLGrammarPreparser() {
        this(new SymbolTable());
    }

    public XMLGrammarPreparser(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fLoaders = new Hashtable();
        this.fErrorReporter = new XMLErrorReporter();
        this.setLocale(Locale.getDefault());
        this.fEntityResolver = new XMLEntityManager();
    }

    public boolean registerPreparser(String string, XMLGrammarLoader xMLGrammarLoader) {
        if (xMLGrammarLoader == null) {
            if (KNOWN_LOADERS.containsKey(string)) {
                String string2 = (String)KNOWN_LOADERS.get(string);
                try {
                    XMLGrammarLoader xMLGrammarLoader2 = (XMLGrammarLoader)ObjectFactory.newInstance(string2, true);
                    this.fLoaders.put(string, xMLGrammarLoader2);
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }
            return false;
        }
        this.fLoaders.put(string, xMLGrammarLoader);
        return true;
    }

    public Grammar preparseGrammar(String string, XMLInputSource xMLInputSource) throws XNIException, IOException {
        if (this.fLoaders.containsKey(string)) {
            XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)this.fLoaders.get(string);
            xMLGrammarLoader.setProperty(SYMBOL_TABLE, this.fSymbolTable);
            xMLGrammarLoader.setProperty(ENTITY_RESOLVER, this.fEntityResolver);
            xMLGrammarLoader.setProperty(ERROR_REPORTER, this.fErrorReporter);
            if (this.fGrammarPool != null) {
                try {
                    xMLGrammarLoader.setProperty(GRAMMAR_POOL, this.fGrammarPool);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return xMLGrammarLoader.loadGrammar(xMLInputSource);
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
        this.fErrorReporter.setLocale(locale);
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, xMLErrorHandler);
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fEntityResolver = xMLEntityResolver;
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public void setGrammarPool(XMLGrammarPool xMLGrammarPool) {
        this.fGrammarPool = xMLGrammarPool;
    }

    public XMLGrammarPool getGrammarPool() {
        return this.fGrammarPool;
    }

    public XMLGrammarLoader getLoader(String string) {
        return (XMLGrammarLoader)this.fLoaders.get(string);
    }

    public void setFeature(String string, boolean bl) {
        Enumeration enumeration = this.fLoaders.elements();
        while (enumeration.hasMoreElements()) {
            XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)enumeration.nextElement();
            try {
                xMLGrammarLoader.setFeature(string, bl);
            }
            catch (Exception exception) {}
        }
        if (string.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, bl);
        }
    }

    public void setProperty(String string, Object object) {
        Enumeration enumeration = this.fLoaders.elements();
        while (enumeration.hasMoreElements()) {
            XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)enumeration.nextElement();
            try {
                xMLGrammarLoader.setProperty(string, object);
            }
            catch (Exception exception) {}
        }
    }

    public boolean getFeature(String string, String string2) {
        XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)this.fLoaders.get(string);
        return xMLGrammarLoader.getFeature(string2);
    }

    public Object getProperty(String string, String string2) {
        XMLGrammarLoader xMLGrammarLoader = (XMLGrammarLoader)this.fLoaders.get(string);
        return xMLGrammarLoader.getProperty(string2);
    }

    static {
        KNOWN_LOADERS.put("http://www.w3.org/2001/XMLSchema", "com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaLoader");
        KNOWN_LOADERS.put("http://www.w3.org/TR/REC-xml", "com.sun.org.apache.xerces.internal.impl.dtd.XMLDTDLoader");
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER, ERROR_HANDLER, ENTITY_RESOLVER, GRAMMAR_POOL};
    }
}

