{****************************************************************************************

"TocToScript" HelpNDoc script. Copyright (c) IBE Software
---------------------------------------------------------
Generates an HelpNDoc script to re-create the table of contents. Once the script is
generated, it can be re-executed into HelpNDoc's script editor to re-create the
table of contents hierarchy.

Customization:
--------------
* OUTPUT_FILE => use it to specify the path of the generated script file

****************************************************************************************}

const
  // Update the path of the output file to generate
  OUTPUT_FILE = 'c:\tmp\toc.hnd.pas';

var
  aScript: TStringList;
  aTopicNb: integer; 
  
  procedure ExportTopics(aTopicParent: string; aParentNb: integer);
  var
    aTopicList: THndTopicsInfoArray;
    nTopic: integer;
  begin
    // Get children
    aTopicList := HndTopics.GetTopicDirectChildrenList(aTopicParent);
    // Iterate children
    for nTopic := 0 to High(aTopicList) do
    begin     
      Inc(aTopicNb);
      // Create the topic
      aScript.Add(format('    // Topic #%d', [aTopicNb]));
      aScript.Add('    aTopicList.Add(HndTopics.CreateTopic());');
      // Set its properties
      aScript.Add(format('    HndTopics.SetTopicCaption(aTopicList[%d], ''%s'');', [aTopicNb, StringReplace(HndTopics.GetTopicCaption(aTopicList[nTopic].Id), '''', '''''', [rfReplaceAll])]));
      aScript.Add(format('    HndTopics.SetTopicHelpId(aTopicList[%d], ''%s'');', [aTopicNb, aTopicList[nTopic].HelpId]));
      aScript.Add(format('    HndTopics.SetTopicHelpContext(aTopicList[%d], %d);', [aTopicNb, aTopicList[nTopic].HelpContext]));
      aScript.Add(format('    HndTopics.SetTopicIconIndex(aTopicList[%d], %d);', [aTopicNb, HndTopics.GetTopicIconIndex(aTopicList[nTopic].Id)])); 
      // Move topic
	  if aParentNb >= 0 then
       aScript.Add(format('    HndTopics.MoveTopic(aTopicList[%d], aTopicList[%d], htamAddChild);', [aTopicNb, aParentNb]));
	  // Handle children topics
	  ExportTopics(aTopicList[nTopic].Id, aTopicNb);    
    end;
  end;

begin
  // Setup
  aScript := TStringList.Create;
  try
    // Init
    aTopicNb := -1;
    // Start script
    aScript.Add('var');         
	aScript.Add('  aTopicList: TStringList;');
    aScript.Add('');
    aScript.Add('begin');
    aScript.Add('  aTopicList := TStringList.Create();');
    aScript.Add('  try');
    // Export root topics
    ExportTopics(HndTopics.GetProjectTopic(), -1);
    // Close script             
    aScript.Add('  finally');
    aScript.Add('    aTopicList.Free;');
    aScript.Add('  end;');
    aScript.Add('end.');
	// Save script to file
    aScript.SaveToFile(OUTPUT_FILE);
  finally
    aScript.Free;
  end;  
end.