{****************************************************************************************

"ReplaceLibItems" HelpNDoc script. Copyright (c) IBE Software
-------------------------------------------------------------
See: http://www.helpndoc.com/articles/2015-04-27-easily-update-path-your-external-media-elements-when-they-are-moved
If some external library items have been moved, this scripts makes it easy to update
them with the new page. It will go through all external library items and replace the
initial path with the new one.

Customization:
--------------
* REPLACE_FROM => the initial library item's path to replace
* REPLACE_TO => the new path to use for those library items

****************************************************************************************}

const
  // Search for library items with that specific path
  REPLACE_FROM = 'c:\doc';
  // When found, replace with that one
  REPLACE_TO   = 'd:\documentation';

var
  aList: THndLibraryItemsInfoArray;
  nCnt: Integer;
  sFilePath: string;

begin
  // Get all items in the library
  aList := HndLibraryItems.GetItemList([]);
  // Go through each of them
  for nCnt := 0 to Length(aList) - 1 do
  begin
    // Get its file location
    sFilePath := HndLibraryItems.GetItemUrlFile(aList[nCnt].id);
    // Do we need to replace this one ?
    if ((sFilePath <> '') and (Pos(UpperCase(REPLACE_FROM), UpperCase(sFilePath)) > 0)) then
    begin
      // Yes we do: update the path
      sFilePath := StringReplace(sFilePath, REPLACE_FROM, REPLACE_TO, [rfIgnoreCase]);
      // Save it
      HndLibraryItems.SetItemUrlFile(aList[nCnt].id, sFilePath);
    end;
  end;
end.