{****************************************************************************************

"ExportHelpIdsandContexts" HelpNDoc script. Copyright (c) IBE Software
----------------------------------------------------------------------
See: http://www.helpndoc.com/articles/2014-11-19-how-export-help-ids-and-help-context-numbers-your-developers
Use this script to create a text file with a list of all topics in the project, their
help Ids and help context.

Customization:
--------------
* OUTPUT_FILE => the text file to generate with the list of topics

****************************************************************************************}

const
  // Define the output file
  OUTPUT_FILE = 'c:\tmp\topics.txt';

var
  // Current topic ID
  aTopicId: string;
  // List of output
  aList: TStringList;

begin
  // Init list
  aList := TStringList.Create;
  aList.Add('Topic Caption | Help ID | Help Context');
  aList.Add('--------------------------------------');
  try
    // Get first topic
    aTopicId := HndTopics.GetTopicFirst();
    // Loop through all topics
    while aTopicId <> '' do
    begin
      // Add the topic to the list
      aList.Add(Format('%s | %s | %d', [
        HndTopics.GetTopicCaption(aTopicId),
        HndTopics.GetTopicHelpId(aTopicId),
        HndTopics.GetTopicHelpContext(aTopicId)
      ]));
      // Get next topic
      aTopicId := HndTopics.GetTopicNext(aTopicId);
    end;
    // Create the file
    aList.SaveToFile(OUTPUT_FILE);
  finally
    aList.Free;
  end;
end.